/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.threads.ThreadProcessResult;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BudgetOfDailyInterceptor
extends AbstractInterceptor
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BudgetOfDailyInterceptor.class);
    @Autowired
    private TicketStatisticsService ticketStatisticsService;
    @Autowired
    private TicketService ticketService;
    private final ExecutorService pool;

    public BudgetOfDailyInterceptor(AdsProdConfiguration configuration) {
        this.pool = new ThreadPoolExecutor(configuration.getFilter().getPoolCoreSize(), configuration.getFilter().getMaxinumCoreSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("bod"));
    }

    public void destroy() throws Exception {
        this.pool.shutdown();
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        List<TicketCache> tickets = requestModel.getTickets();
        ArrayList futures = Lists.newArrayList();
        for (TicketCache ticketCache : tickets) {
            Future<ThreadProcessResult> future = this.pool.submit(new Process(this.ticketService, this.ticketStatisticsService, ticketCache));
            futures.add(future);
        }
        HashSet deleted = Sets.newHashSet();
        for (Future<ThreadProcessResult> future : futures) {
            try {
                ThreadProcessResult result = (ThreadProcessResult)future.get();
                if (!result.isDeleteIfNeeded()) continue;
                deleted.add(result.getTicketId());
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("get:", (Throwable)e);
            }
        }
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger id = ticket.getId();
            if (!deleted.contains(id)) continue;
            requestModel.addFilterMessage((Object)this, String.valueOf(id));
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[BudgetOfDailyInterceptor] Removed {}", (Object)id);
        }
    }

    private static class Process
    implements Callable<ThreadProcessResult> {
        private final TicketService ticketService;
        private final TicketStatisticsService ticketStatisticsService;
        private final TicketCache ticket;

        Process(TicketService ticketService, TicketStatisticsService ticketStatisticsService, TicketCache ticket) {
            this.ticketService = ticketService;
            this.ticketStatisticsService = ticketStatisticsService;
            this.ticket = ticket;
        }

        @Override
        public ThreadProcessResult call() throws Exception {
            BigInteger id = this.ticket.getId();
            Ticket t = this.ticketService.get(id);
            int budgetDaily = NumberUtils.toInt((String)String.valueOf(t.getBudgetDaily()));
            long crtBudgetOfToday = this.ticketStatisticsService.getBudgetOfToday(id);
            return crtBudgetOfToday >= (long)budgetDaily ? ThreadProcessResult.DELETE(id) : ThreadProcessResult.UNDELETE(id);
        }
    }
}

