/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FilterRequestModel
implements Serializable {
    private static final long serialVersionUID = 4654851721352400959L;
    private Position position;
    private String uid;
    private String imei;
    private int platform = 0;
    private int os = 4;
    private int app = 0;
    private String ip;
    private IP iprst;
    private List<TicketCache> tickets;
    private Map<Object, List<String>> filterMessage = Maps.newHashMap();

    public void addFilterMessage(Object interceptor, String message) {
        if (!this.filterMessage.containsKey(interceptor)) {
            this.filterMessage.put(interceptor, Lists.newArrayList());
        }
        List<String> list = this.filterMessage.get(interceptor);
        list.add(message);
    }

    public boolean isNoImei() {
        String imei = this.getImei();
        return StringUtils.isBlank((String)this.getImei()) || StringUtils.equals((String)"__IMEI__", (String)imei);
    }

    public Map<Object, List<String>> getFilterMessage() {
        return Collections.unmodifiableMap(this.filterMessage);
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public boolean isEmpty() {
        return null == this.tickets || this.tickets.size() == 0;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public List<TicketCache> getTickets() {
        return this.tickets;
    }

    public void setTickets(List<TicketCache> tickets) {
        this.tickets = tickets;
    }

    public int getPlatform() {
        return this.platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return this.os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return this.app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public IP getIprst() {
        return this.iprst;
    }

    public void setIprst(IP iprst) {
        this.iprst = iprst;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}

