/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.alibaba.fastjson.JSON;
import com.bxm.adsprod.facade.media.AdMediaTagMsg;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MediaTagInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTagInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public MediaTagInterceptor() {
    }

    public MediaTagInterceptor(Interceptor next) {
        super(next);
    }

    public static void main(String[] args) {
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel == null && requestModel.isEmpty()) {
            return;
        }
        List<TicketCache> tickets = requestModel.getTickets();
        if (CollectionUtils.isEmpty(tickets)) {
            return;
        }
        Position position = requestModel.getPosition();
        if (null == position) {
            throw new NullPointerException("media cannot be null");
        }
        String positionId = position.getId();
        if (StringUtils.isBlank((String)positionId)) {
            return;
        }
        String ticketIds = (String)this.fetcher.fetch(TicketKeyGenerator.Media.getPositionWhiteTicketId((String)positionId), String.class);
        if (StringUtils.isNotBlank((String)ticketIds)) {
            this.dealByWhiteTickets(tickets, ticketIds);
            return;
        }
        String regionCode = requestModel.getIprst().getRegioncode();
        if (StringUtils.isBlank((String)regionCode)) {
            regionCode = "000000";
        }
        Integer hour = TypeHelper.castToInt((Object)DateHelper.format((String)"HH"));
        List<AdMediaTagMsg> mediaTags = this.getAdMediaTags(positionId);
        if (CollectionUtils.isEmpty(mediaTags)) {
            return;
        }
        Set<String> tags = this.getDisabledTags(mediaTags, regionCode, hour);
        if (CollectionUtils.isEmpty(tags)) {
            return;
        }
        this.dealTickets(requestModel, tickets, tags);
    }

    private void dealTickets(FilterRequestModel requestModel, List<TicketCache> tickets, Set<String> tags) {
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            List ticketTags = ticket.getTags();
            if (CollectionUtils.isEmpty((Collection)ticketTags)) continue;
            HashSet<String> ticketTagCodes = new HashSet<String>();
            for (Tag tag : ticketTags) {
                ticketTagCodes.add(tag.getCode());
            }
            ticketTagCodes.retainAll(tags);
            if (!CollectionUtils.isNotEmpty(ticketTagCodes)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[MediaTagInterceptor] remove {}.", (Object)ticket.getId());
            }
            requestModel.addFilterMessage((Object)this, String.valueOf(ticket.getId()));
            iterator.remove();
        }
    }

    private Set<String> getDisabledTags(List<AdMediaTagMsg> mediaTags, String regionCode, Integer hour) {
        HashSet<String> tags = new HashSet<String>();
        if (CollectionUtils.isEmpty(mediaTags)) {
            return tags;
        }
        if (regionCode != null && regionCode.endsWith("0000")) {
            mediaTags.forEach(mediaTag -> {
                Set regions = mediaTag.getRegions();
                HashSet newRegions = new HashSet();
                if (CollectionUtils.isNotEmpty((Collection)regions)) {
                    regions.forEach(region -> newRegions.add(region.substring(0, 2) + "0000"));
                }
                mediaTag.setRegions(newRegions);
            });
        }
        String provice = regionCode.substring(0, 2) + "0000";
        for (AdMediaTagMsg mediaTag2 : mediaTags) {
            Set regions = mediaTag2.getRegions();
            Set times = mediaTag2.getTimes();
            if (CollectionUtils.isNotEmpty((Collection)regions) && CollectionUtils.isNotEmpty((Collection)times)) {
                if (!regions.contains(regionCode) && !regions.contains(provice) || !times.contains(hour)) continue;
                tags.add(mediaTag2.getTag());
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)regions) && CollectionUtils.isNotEmpty((Collection)times)) {
                if (!times.contains(hour)) continue;
                tags.add(mediaTag2.getTag());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)regions) && CollectionUtils.isEmpty((Collection)times)) {
                if (!regions.contains(regionCode) && !regions.contains(provice)) continue;
                tags.add(mediaTag2.getTag());
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)regions) || !CollectionUtils.isEmpty((Collection)times)) continue;
            tags.add(mediaTag2.getTag());
        }
        return tags;
    }

    private List<AdMediaTagMsg> getAdMediaTags(String positionId) {
        String fetch = (String)this.fetcher.fetch(TicketKeyGenerator.Media.getMediaTag((String)positionId), String.class);
        return JSON.parseArray((String)fetch, AdMediaTagMsg.class);
    }

    private void dealByWhiteTickets(List<TicketCache> tickets, String ticketIds) {
        List<String> ticketIdList = Arrays.asList(ticketIds.split(","));
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            if (ticketIdList.contains(ticket.getId().toString())) continue;
            iterator.remove();
        }
    }
}

