/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.service.media.PositionIdResolver;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Deprecated
@Configuration
@EnableConfigurationProperties(value={JedisConfiguration.class})
public class PositionTagRegionForOldInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTagRegionForOldInterceptor.class);
    private static final int VALUE_SPLIT_SIZE = 2;
    @Autowired
    private JedisConfiguration configuration;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher fetcher;

    protected void doIntercept(Invocation invocation) {
        List<BigInteger> appBlack;
        String time;
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        IP iprst = requestModel.getIprst();
        String c = iprst.getCity();
        String city = c + "\u5e02";
        if (StringUtils.isBlank((String)c)) {
            city = iprst.getProvince() + "\u7701";
        }
        if (StringUtils.isBlank((String)(time = this.getTimeFromFetcher()))) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cloud not found 'time' value from fetcher.");
            }
            return;
        }
        Position position = requestModel.getPosition();
        String positionId = position.getId();
        if (StringUtils.isBlank((String)positionId)) {
            return;
        }
        String[] resolve = PositionIdResolver.DEFAULT.resolve(positionId);
        if (null == resolve || resolve.length != 2) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Illegal positionId: {}", (Object)position.getId());
            }
            return;
        }
        String appkey = resolve[0];
        String business = resolve[1];
        List<TicketCache> tickets = requestModel.getTickets();
        List<BigInteger> appAreaBlack = this.getAppAreaBlack(time, KeyBuilder.build((Object[])new Object[]{appkey, business, city}));
        if (CollectionUtils.isNotEmpty(appAreaBlack)) {
            this.loopRemove(requestModel, tickets, appAreaBlack, true);
        }
        if (CollectionUtils.isNotEmpty(appBlack = this.getAppBlack(time, KeyBuilder.build((Object[])new Object[]{appkey, business})))) {
            this.loopRemove(requestModel, tickets, appBlack, true);
            return;
        }
        List<BigInteger> appWhite = this.getAppWhite(time, KeyBuilder.build((Object[])new Object[]{appkey, business}));
        if (CollectionUtils.isNotEmpty(appWhite)) {
            this.loopRemove(requestModel, tickets, appWhite, false);
        }
    }

    private void loopRemove(FilterRequestModel requestModel, List<TicketCache> tickets, List<BigInteger> cache, boolean blacklist) {
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            boolean removing = blacklist && cache.contains(ticketId) || !blacklist && !cache.contains(ticketId);
            if (!removing) continue;
            iterator.remove();
            requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[PositionTagRegionForOldInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private String getTimeFromFetcher() {
        return (String)this.fetcher.fetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"certificate", "real", "key"});
            }
        }, null, String.class);
    }

    private List<BigInteger> getAppAreaBlack(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app_area", "black", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }

    private List<BigInteger> getAppBlack(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app", "black", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }

    private List<BigInteger> getAppWhite(final String time, String field) {
        String cache = (String)this.fetcher.hfetch(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"app", "white", time});
            }
        }, field, null, String.class);
        if (StringUtils.isBlank((String)cache)) {
            return null;
        }
        return JSONArray.parseArray((String)cache, BigInteger.class);
    }
}

