/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class PositionTagRegionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionTagRegionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public PositionTagRegionInterceptor() {
    }

    public PositionTagRegionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        Position position = requestModel.getPosition();
        if (null == position) {
            throw new NullPointerException("media cannot be null");
        }
        String positionId = position.getId();
        IP iprst = requestModel.getIprst();
        String regionCode = iprst.getRegioncode();
        if (StringUtils.isBlank((String)regionCode)) {
            return;
        }
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        block0: while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            List tags = ticket.getTags();
            if (CollectionUtils.isEmpty((Collection)tags)) continue;
            for (Tag tag : tags) {
                String code = tag.getCode();
                HashMap parameters = Maps.newHashMap();
                parameters.put("positionid", positionId);
                parameters.put("tagcode", code);
                Set filters = (Set)this.fetcher.fetch(PositionTagRegionInterceptor.keyGenerator(parameters), null, Set.class);
                if (CollectionUtils.isEmpty((Collection)filters) || !filters.contains(regionCode)) continue;
                iterator.remove();
                if (!LOGGER.isDebugEnabled()) continue block0;
                LOGGER.debug("[PositionTagRegionInterceptor] remove {}.", (Object)ticketId);
                continue block0;
            }
        }
    }

    public static KeyGenerator keyGenerator(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG", parameters.get("positionid"), parameters.get("tagcode")});
            }
        };
    }
}

