/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketGroupPushVo;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TicketGroupInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGroupInterceptor.class);
    private static final Integer EVERY_DAY = 1;
    private static final Integer EVERY_WEEK = 2;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public TicketGroupInterceptor() {
    }

    public TicketGroupInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        HashMap<Long, TicketGroupPushVo> mapTicketGroup = new HashMap<Long, TicketGroupPushVo>();
        HashSet<Long> outGrouIds = new HashSet<Long>();
        if (requestModel == null && requestModel.isEmpty()) {
            return;
        }
        List<TicketCache> tickets = requestModel.getTickets();
        String uid = requestModel.getUid();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            Long groupId = ticket.getGroupId();
            if (groupId == null) continue;
            if (!CollectionUtils.isEmpty(outGrouIds) && outGrouIds.contains(groupId)) {
                iterator.remove();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[TicketGroupInterceptor] remove {}.", (Object)ticket.getId());
                continue;
            }
            TicketGroupPushVo ticketGroupPushVo = mapTicketGroup.getOrDefault(groupId, null);
            if (ticketGroupPushVo == null) {
                ticketGroupPushVo = (TicketGroupPushVo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup((BigInteger)BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
                mapTicketGroup.put(groupId, ticketGroupPushVo);
            }
            Integer openNum = ticketGroupPushVo.getOpenFrequencyNum();
            Integer clickNum = ticketGroupPushVo.getClickFrequencyNum();
            if (!ticketGroupPushVo.isEnabled()) continue;
            Integer openFrequency = ticketGroupPushVo.getOpenFrequency();
            Integer clickFrequency = ticketGroupPushVo.getClickFrequency();
            AbstractFrequency frequency = new AbstractFrequencyFactory().getOpenFrequency(openFrequency, openNum, groupId, uid);
            if (frequency == null) {
                frequency = new AbstractFrequencyFactory().getClickFrequency(clickFrequency, clickNum, groupId, uid);
            } else {
                frequency.setNext(new AbstractFrequencyFactory().getClickFrequency(clickFrequency, clickNum, groupId, uid));
            }
            if (frequency == null || frequency.checkFrequency()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[TicketGroupInterceptor] remove {}.", (Object)ticket.getId());
            }
            requestModel.addFilterMessage((Object)this, String.valueOf(ticket.getId()));
            iterator.remove();
            outGrouIds.add(groupId);
        }
    }

    class AbstractFrequencyFactory {
        AbstractFrequencyFactory() {
        }

        AbstractFrequency getClickFrequency(Integer frequency, Integer num, Long groupId, String uid) {
            if (EVERY_DAY.equals(frequency)) {
                Integer currentNum = (Integer)TicketGroupInterceptor.this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyClickKey((Long)groupId), uid, Integer.class);
                return new OpenDailyFrequency(num, currentNum);
            }
            if (EVERY_WEEK.equals(frequency)) {
                Integer currentNum = (Integer)TicketGroupInterceptor.this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupWeekClickKey((Long)groupId), uid, Integer.class);
                return new OpenWeekFrequency(num, currentNum);
            }
            return null;
        }

        public AbstractFrequency getOpenFrequency(Integer frequency, Integer num, Long groupId, String uid) {
            if (EVERY_DAY.equals(frequency)) {
                Integer currentNum = (Integer)TicketGroupInterceptor.this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey((Long)groupId), uid, Integer.class);
                return new ClickDailyFrequency(num, currentNum);
            }
            if (EVERY_WEEK.equals(frequency)) {
                Integer currentNum = (Integer)TicketGroupInterceptor.this.fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupWeekViewKey((Long)groupId), uid, Integer.class);
                return new ClickWeekFrequency(num, currentNum);
            }
            return null;
        }
    }

    class OpenWeekFrequency
    extends AbstractFrequency {
        protected OpenWeekFrequency(Integer num, Integer currentNum) {
            super(num, currentNum);
        }
    }

    class OpenDailyFrequency
    extends AbstractFrequency {
        protected OpenDailyFrequency(Integer num, Integer currentNum) {
            super(num, currentNum);
        }
    }

    class ClickWeekFrequency
    extends AbstractFrequency {
        protected ClickWeekFrequency(Integer num, Integer currentNum) {
            super(num, currentNum);
        }
    }

    class ClickDailyFrequency
    extends AbstractFrequency {
        protected ClickDailyFrequency(Integer num, Integer currentNum) {
            super(num, currentNum);
        }
    }

    abstract class AbstractFrequency {
        protected Integer num;
        protected Integer currentNum;
        protected AbstractFrequency next;

        protected AbstractFrequency(Integer num, Integer currentNum) {
            this.num = num == null ? 0 : num;
            this.currentNum = currentNum == null ? 0 : currentNum;
        }

        public void setNext(AbstractFrequency next) {
            this.next = next;
        }

        public boolean checkFrequency() {
            if (this.currentNum >= this.num) {
                return false;
            }
            if (this.next != null) {
                return this.next.checkFrequency();
            }
            return true;
        }
    }
}

