/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.utils.IpUtils;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.dto.AdTicketIpDto;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketIpLibraryInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketIpLibraryInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    private LoadingCache<String, List<AdTicketIpDto>> ipLibraryCache = CacheBuilder.newBuilder().maximumSize(10L).refreshAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<AdTicketIpDto>>(){

        public List<AdTicketIpDto> load(String key) {
            return TicketIpLibraryInterceptor.this.fetcher.hfetchList(TicketKeyGenerator.Filter.getIpLibrary(), key, AdTicketIpDto.class);
        }
    });

    public TicketIpLibraryInterceptor() {
    }

    public TicketIpLibraryInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        int ip = IpUtils.getIntIp((String)requestModel.getIp());
        KeyGenerator keyGenerator = TicketKeyGenerator.Filter.getIpLibraryDefined();
        Map maps = this.fetcher.hfetchall(keyGenerator, null, Set.class);
        if (MapUtils.isEmpty((Map)maps)) {
            return;
        }
        List<TicketCache> tickets = requestModel.getTickets();
        for (String channel : maps.keySet()) {
            Set ticketIds = (Set)maps.get(channel);
            if (CollectionUtils.isEmpty((Collection)ticketIds)) continue;
            try {
                this.filterTicketByChannel(ip, tickets, channel, ticketIds);
            }
            catch (ExecutionException e) {
                return;
            }
        }
    }

    private void filterTicketByChannel(int ip, List<TicketCache> tickets, String channel, Set<String> ticketIds) throws ExecutionException {
        long now = System.currentTimeMillis();
        boolean isFilter = false;
        boolean isPass = true;
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            String ticketId = ticket.getId().toString();
            if (!ticketIds.contains(ticketId)) continue;
            if (!isFilter) {
                List ipLibs = (List)this.ipLibraryCache.get((Object)channel);
                if (CollectionUtils.isEmpty((Collection)ipLibs)) continue;
                if (!TicketIpLibraryInterceptor.inIpLibrary(ipLibs, ip)) {
                    isPass = false;
                    this.removeTicket(iterator, ticketId, ip);
                }
                isFilter = true;
                continue;
            }
            if (isPass) continue;
            this.removeTicket(iterator, ticketId, ip);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketIpLibraryInterceptor] filter cannel{} cast {} ms", (Object)channel, (Object)(System.currentTimeMillis() - now));
        }
    }

    private void removeTicket(Iterator<TicketCache> iterator, String ticketId, int ip) {
        iterator.remove();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketIpLibraryInterceptor] remove {}.ip={}", (Object)ticketId, (Object)IpUtils.getStringIp((int)ip));
        }
    }

    private static boolean inIpLibrary(List<AdTicketIpDto> list, int ip) {
        int start = 0;
        int end = list.size() - 1;
        while (start <= end) {
            int mid = start + (end - start) / 2;
            AdTicketIpDto dto = list.get(mid);
            if (ip < dto.getStartIp()) {
                end = mid - 1;
                continue;
            }
            if (ip > dto.getEndIp()) {
                start = mid + 1;
                continue;
            }
            return true;
        }
        return false;
    }
}

