/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.so.rules.PositionGroupRuleSo;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.threads.ThreadProcessResult;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketPositionGroupInterceptor
extends AbstractInterceptor
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionGroupInterceptor.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private PositionGroupService positionGroupService;
    private final ExecutorService pool;

    public TicketPositionGroupInterceptor(AdsProdConfiguration configuration) {
        this.pool = new ThreadPoolExecutor(configuration.getFilter().getPoolCoreSize(), configuration.getFilter().getMaxinumCoreSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("pg"));
    }

    public void destroy() throws Exception {
        this.pool.shutdown();
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        Position position = requestModel.getPosition();
        String positionId = position.getId();
        List<TicketCache> tickets = requestModel.getTickets();
        ArrayList futures = Lists.newArrayList();
        for (TicketCache ticketCache : tickets) {
            Future<ThreadProcessResult> future = this.pool.submit(new Process(this.fetcher, this.positionGroupService, ticketCache.getId(), positionId));
            futures.add(future);
        }
        HashSet deleted = Sets.newHashSet();
        for (Future<ThreadProcessResult> future : futures) {
            try {
                ThreadProcessResult result = (ThreadProcessResult)future.get();
                if (!result.isDeleteIfNeeded()) continue;
                deleted.add(result.getTicketId());
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("get:", (Throwable)e);
            }
        }
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger id = ticket.getId();
            if (!deleted.contains(id)) continue;
            requestModel.addFilterMessage((Object)this, String.valueOf(id));
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketPositionGroupInterceptor] Removed {}", (Object)id);
        }
    }

    private static class Process
    implements Callable<ThreadProcessResult> {
        private final Fetcher fetcher;
        private final PositionGroupService positionGroupService;
        private final BigInteger ticketId;
        private final String positionId;

        Process(Fetcher fetcher, PositionGroupService positionGroupService, BigInteger ticketId, String positionId) {
            this.fetcher = fetcher;
            this.positionGroupService = positionGroupService;
            this.ticketId = ticketId;
            this.positionId = positionId;
        }

        @Override
        public ThreadProcessResult call() throws Exception {
            PositionGroupRuleSo.Entry config = (PositionGroupRuleSo.Entry)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionGroup((BigInteger)this.ticketId), this.positionId, PositionGroupRuleSo.Entry.class);
            if (null == config) {
                return ThreadProcessResult.UNDELETE(this.ticketId);
            }
            String groupId = config.getGroupId();
            long limit = config.getLimit();
            Long budget = this.positionGroupService.getBudgetOfToday(this.ticketId, groupId);
            return budget >= limit && limit > 0L ? ThreadProcessResult.DELETE(this.ticketId) : ThreadProcessResult.UNDELETE(this.ticketId);
        }
    }
}

