/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketPositionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public TicketPositionInterceptor() {
    }

    public TicketPositionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        Position position = requestModel.getPosition();
        String id = position.getId();
        if (StringUtils.isBlank((String)id)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Position id can not be null.");
            }
            return;
        }
        Set whiteList = (Set)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionDefinedWhiteList(), id, Set.class);
        Set blackList = (Set)this.fetcher.hfetch(TicketKeyGenerator.Filter.getPositionDefinedBlackList(), id, Set.class);
        Set undefined = (Set)this.fetcher.fetch(TicketKeyGenerator.Filter.getPositionUndefined(), Set.class);
        Set whiteConf = (Set)this.fetcher.fetch(TicketKeyGenerator.Filter.getPositionDefinedWhiteConf(), Set.class);
        Set blackConf = (Set)this.fetcher.fetch(TicketKeyGenerator.Filter.getPositionDefinedBlackConf(), Set.class);
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            String strTicketId = String.valueOf(ticketId);
            if (this.isContains(undefined, strTicketId)) continue;
            if (this.isContains(whiteConf, strTicketId)) {
                boolean atWhiteList = null != whiteList && whiteList.contains(strTicketId);
                if (atWhiteList) continue;
                this.doRemoved(requestModel, iterator, strTicketId);
                continue;
            }
            if (this.isContains(blackConf, strTicketId)) {
                boolean atBlackList = null != blackList && blackList.contains(strTicketId);
                if (!atBlackList) continue;
                this.doRemoved(requestModel, iterator, strTicketId);
                continue;
            }
            this.doRemoved(requestModel, iterator, strTicketId);
        }
    }

    private void doRemoved(FilterRequestModel requestModel, Iterator<TicketCache> iterator, String strTicketId) {
        requestModel.addFilterMessage((Object)this, strTicketId);
        iterator.remove();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketPositionInterceptor] remove {}.", (Object)strTicketId);
        }
    }

    private boolean isContains(Set<String> data, String o) {
        return null != data && data.contains(o);
    }
}

