/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketRegionInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegionInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired(required=false)
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public TicketRegionInterceptor() {
    }

    public TicketRegionInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        String generateCode = "000000";
        String regionCode = StringUtils.defaultIfEmpty((String)requestModel.getIprst().getRegioncode(), (String)"000000");
        Set undefined = (Set)this.fetcher.fetch(TicketKeyGenerator.Filter.getRegionUndefined(), null, Set.class);
        Set openTickets = (Set)this.fetcher.hfetch(TicketKeyGenerator.Filter.getRegionDefined(), regionCode, null, Set.class);
        Set openTicketsProvince = (Set)this.fetcher.hfetch(TicketKeyGenerator.Filter.getRegionDefined(), this.getCodeForProvince(regionCode), null, Set.class);
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            boolean isNotContainsProvinceOpenTickets;
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            if (this.isUndefined(undefined, ticketId)) continue;
            String strTicketId = String.valueOf(ticketId);
            boolean isNotContainsCityOpenTickets = null == openTickets || !openTickets.contains(strTicketId);
            boolean bl = isNotContainsProvinceOpenTickets = null == openTicketsProvince || !openTicketsProvince.contains(strTicketId);
            if (!isNotContainsCityOpenTickets || !isNotContainsProvinceOpenTickets) continue;
            requestModel.addFilterMessage((Object)this, strTicketId);
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketRegionInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private boolean isUndefined(Set<String> undefined, BigInteger ticketId) {
        return null != undefined && undefined.contains(String.valueOf(ticketId));
    }

    private String getCodeForProvince(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)2), (int)6, (String)"0");
    }
}

