/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.times.TimesRuleProcessor;
import com.bxm.adsprod.service.ticket.filter.times.TimesRuleProcessorFactory;
import com.bxm.adsprod.service.user.UserStatisticsService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketTimesInterceptor
extends AbstractInterceptor
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketTimesInterceptor.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private UserStatisticsService userStatisticsService;
    private final ExecutorService pool;

    public TicketTimesInterceptor(AdsProdConfiguration configuration) {
        this.pool = new ThreadPoolExecutor(configuration.getFilter().getPoolCoreSize(), configuration.getFilter().getMaxinumCoreSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("times"));
    }

    public void destroy() {
        this.pool.shutdown();
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        final String uid = requestModel.getUid();
        if (StringUtils.isBlank((String)uid)) {
            throw new NullPointerException("uid cannot be blank");
        }
        ArrayList futures = Lists.newArrayList();
        List<TicketCache> tickets = requestModel.getTickets();
        for (final TicketCache ticket : tickets) {
            Future<ProcessResult> future = this.pool.submit(new Callable<ProcessResult>(){

                @Override
                public ProcessResult call() throws Exception {
                    BigInteger ticketId = ticket.getId();
                    HashMap parameters = Maps.newHashMap();
                    parameters.put("ticketid", ticketId);
                    TicketTimesRuleSo rule = (TicketTimesRuleSo)TicketTimesInterceptor.this.fetcher.fetch(TicketKeyGenerator.getTimes((Map)parameters), null, TicketTimesRuleSo.class);
                    if (null == rule) {
                        return ProcessResult.undeleted(ticketId);
                    }
                    List entries = rule.getEntries();
                    for (TicketTimesRuleSo.Entry entry : entries) {
                        TimesRuleProcessor processor = TimesRuleProcessorFactory.create(TicketTimesInterceptor.this.userStatisticsService, entry);
                        if (!processor.isOutOfTimes(uid, ticketId)) continue;
                        return ProcessResult.deleted(ticketId);
                    }
                    return ProcessResult.undeleted(ticketId);
                }
            });
            futures.add(future);
        }
        HashSet deleteds = Sets.newHashSet();
        for (Future future : futures) {
            try {
                ProcessResult result = (ProcessResult)future.get();
                if (!result.deleted) continue;
                deleteds.add(result.ticketId);
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("get:", (Throwable)e);
            }
        }
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            if (!deleteds.contains(ticketId)) continue;
            requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
            iterator.remove();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("[TicketTimesInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private static class ProcessResult {
        boolean deleted;
        BigInteger ticketId;

        private ProcessResult() {
        }

        static ProcessResult deleted(BigInteger ticketId) {
            ProcessResult o = new ProcessResult();
            o.deleted = true;
            o.ticketId = ticketId;
            return o;
        }

        static ProcessResult undeleted(BigInteger ticketId) {
            ProcessResult o = new ProcessResult();
            o.deleted = false;
            o.ticketId = ticketId;
            return o;
        }
    }
}

