/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TicketUserAppInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserAppInterceptor.class);

    public TicketUserAppInterceptor() {
    }

    public TicketUserAppInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        int app = requestModel.getApp();
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            boolean isWechatOrAlipay;
            TicketCache ticket = iterator.next();
            if (ticket.getIsSupportWechat() == 3 || app == 0) continue;
            boolean bl = isWechatOrAlipay = app == 1 || app == 2;
            if (ticket.getIsSupportWechat() == 4 && isWechatOrAlipay) {
                this.remove(requestModel, iterator, ticket);
            }
            if (ticket.getIsSupportWechat() == 1 && app == 2) {
                this.remove(requestModel, iterator, ticket);
            }
            if (ticket.getIsSupportWechat() != 2 || app != 1) continue;
            this.remove(requestModel, iterator, ticket);
        }
    }

    private void remove(FilterRequestModel requestModel, Iterator<TicketCache> iterator, TicketCache ticket) {
        requestModel.addFilterMessage((Object)this, String.valueOf(ticket.getId()));
        iterator.remove();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketUserAppInterceptor] remove {}.", (Object)ticket.getId());
        }
    }
}

