/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketOnoff;
import com.bxm.adsprod.facade.user.UserGrade;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketUserGradeInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserGradeInterceptor.class);
    @Autowired
    @Qualifier(value="jedis1Fetcher")
    private Fetcher fetcher;

    public TicketUserGradeInterceptor() {
    }

    public TicketUserGradeInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        UserGrade userGrade = null;
        if (!requestModel.isNoImei()) {
            String imei = requestModel.getImei();
            HashMap parameters = Maps.newHashMap();
            parameters.put("imei", imei);
            userGrade = (UserGrade)this.fetcher.fetch(TicketKeyGenerator.getUser((Map)parameters), null, UserGrade.class);
        }
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            double finalScore;
            UserGrade.Grade grade;
            TicketCache ticket = iterator.next();
            BigInteger ticketId = ticket.getId();
            List onoffs = ticket.getOnoffs();
            if (CollectionUtils.isEmpty((Collection)onoffs)) continue;
            if (requestModel.isNoImei()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u65e0IMEI\u6a21\u5f0f");
                }
                if (!this.removeForPercent(iterator, onoffs, 1)) continue;
                requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
                this.debugRemoved(ticketId);
                continue;
            }
            if (null == userGrade || !userGrade.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u65e0\u6548IMEI\u6a21\u5f0f");
                }
                if (!this.removeForPercent(iterator, onoffs, 2)) continue;
                requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
                this.debugRemoved(ticketId);
                continue;
            }
            Map grades = userGrade.getGrades();
            if (MapUtils.isEmpty((Map)grades) || null == (grade = (UserGrade.Grade)grades.get(ticketId.toString()))) continue;
            Byte isVeto = grade.getIsVeto();
            Double score = grade.getScore();
            if (null != isVeto && isVeto == 1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketUserGradeInterceptor] \u5e7f\u544a\u5238[{}]\u7528\u6237[{}]\u753b\u50cf\u8bc4\u5206[{}]\u88ab\u5426\u51b3\u3002", new Object[]{ticketId, userGrade.getImei(), grade});
                }
                requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
                iterator.remove();
                continue;
            }
            Integer passScore = ticket.getUserGradePassScore();
            if (null == passScore || !((finalScore = NumberUtils.toDouble((String)String.valueOf(score), (double)0.0)) < (double)passScore.intValue())) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[TicketUserGradeInterceptor] \u5e7f\u544a\u5238[{}]\u7528\u6237[{}]\u753b\u50cf[{}]\u5f97\u5206{}<{}\u4e0d\u53ca\u683c\u3002", new Object[]{ticketId, userGrade.getImei(), grade, finalScore, passScore});
            }
            requestModel.addFilterMessage((Object)this, String.valueOf(ticketId));
            iterator.remove();
        }
    }

    private void debugRemoved(BigInteger ticketId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketUserGradeInterceptor] remove {}.", (Object)ticketId);
        }
    }

    private boolean removeForPercent(Iterator<TicketCache> iterator, List<TicketOnoff> onoffs, int type) {
        TicketOnoff conf = this.getFirstItemForType(onoffs, type);
        if (null == conf) {
            iterator.remove();
            return true;
        }
        String value = conf.getValue();
        int percent = NumberUtils.toInt((String)value, (int)0);
        int random = this.random();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u547d\u4e2d\u7387\uff1a{}%\uff0c\u547d\u4e2d\u7ed3\u679c\uff1a{}<={}", new Object[]{percent, random, percent});
        }
        if (percent == 0 || random > percent) {
            iterator.remove();
            return true;
        }
        return false;
    }

    private int random() {
        return RandomUtils.nextInt((int)100) + 1;
    }

    private TicketOnoff getFirstItemForType(List<TicketOnoff> onoffs, int type) {
        for (TicketOnoff onoff : onoffs) {
            Integer t = onoff.getType();
            if (null == t || type != t) continue;
            return onoff;
        }
        return null;
    }

    @Deprecated
    private double resetScore(Byte isVeto, Double score) {
        if (null == isVeto || null == score) {
            return 0.0;
        }
        if (score == -1.0) {
            return 0.0;
        }
        return score * (double)(isVeto == 1 ? -1 : 1);
    }
}

