/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.warcar.integration.interceptor.AbstractInterceptor;
import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TicketUserOsInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserOsInterceptor.class);

    public TicketUserOsInterceptor() {
    }

    public TicketUserOsInterceptor(Interceptor next) {
        super(next);
    }

    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel)invocation.getRequestModel();
        if (requestModel.isEmpty()) {
            return;
        }
        int platform = requestModel.getPlatform();
        int os = requestModel.getOs();
        List<TicketCache> tickets = requestModel.getTickets();
        Iterator<TicketCache> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketCache ticket = iterator.next();
            if (platform == 1) {
                if (os == 1) {
                    boolean supportWechat = ticket.getIsSupportWechat() == 3 || ticket.getIsSupportWechat() == 1;
                    boolean android = ticket.isSupportedOs(1);
                    if (android && supportWechat) continue;
                    this.remove(requestModel, iterator, ticket);
                    continue;
                }
                boolean iosMicroApp = ticket.isSupportedOs(5) && ticket.isSupportedOs(2);
                if (iosMicroApp) continue;
                this.remove(requestModel, iterator, ticket);
                continue;
            }
            if (!ticket.isSupportedOs(5) && ticket.isSupportedOs(os)) continue;
            this.remove(requestModel, iterator, ticket);
        }
    }

    private void remove(FilterRequestModel requestModel, Iterator<TicketCache> iterator, TicketCache ticket) {
        requestModel.addFilterMessage((Object)this, String.valueOf(ticket.getId()));
        iterator.remove();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[TicketUserOsInterceptor] remove {}.", (Object)ticket.getId());
        }
    }
}

