/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.info.impl;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketFilterInformation;
import com.bxm.adsprod.service.ticket.filter.BudgetOfDailyInterceptor;
import com.bxm.adsprod.service.ticket.filter.FilterRequestModel;
import com.bxm.adsprod.service.ticket.filter.MediaTagInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketPositionGroupInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketPositionInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketRegionInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketTimesInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserAppInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserGradeInterceptor;
import com.bxm.adsprod.service.ticket.filter.TicketUserOsInterceptor;
import com.bxm.adsprod.service.ticket.info.TicketFliterInformationInfo;
import com.bxm.adsprod.service.ticket.info.TicketFliterInformationService;
import com.bxm.warcar.integration.message.annotation.Messaging;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TicketFliterInformationServiceImpl
implements TicketFliterInformationService {
    Logger logger = LoggerFactory.getLogger(TicketFliterInformationServiceImpl.class);

    @Override
    @Messaging(topicFieldNameOfConfiguration="filter")
    public TicketFilterInformation getTicketFliterInformation(TicketFliterInformationInfo ticketFliterInformationInfo) {
        Position position = ticketFliterInformationInfo.getPosition();
        List<TicketCache> normals = ticketFliterInformationInfo.getNormals();
        FilterRequestModel requestModel = ticketFliterInformationInfo.getRequestModel();
        TicketFilterInformation ticketFilterInformation = new TicketFilterInformation();
        try {
            String positionId = position.getId();
            if (StringUtils.isNotEmpty((String)positionId)) {
                String[] p = positionId.split("-");
                if (p.length == 2) {
                    ticketFilterInformation.setAppkey(p[0]);
                    ticketFilterInformation.setBusiness("ad-" + p[1]);
                } else {
                    ticketFilterInformation.setAppkey(p[0]);
                }
            }
            if (CollectionUtils.isNotEmpty(normals)) {
                ticketFilterInformation.setFilterresult(normals.stream().filter(ticketCache -> ticketCache.getId() != null).map(ticketCache -> ticketCache.getId().toString()).reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
            }
            ticketFilterInformation.setPt(new Date());
            Map<Object, List<String>> filterMessage = requestModel.getFilterMessage();
            Set<Map.Entry<Object, List<String>>> entries = filterMessage.entrySet();
            for (Map.Entry<Object, List<String>> entry : entries) {
                Object interceptor = entry.getKey();
                List<String> ticketList = entry.getValue();
                if (CollectionUtils.isEmpty(ticketList)) continue;
                if (interceptor instanceof TicketRegionInterceptor) {
                    ticketFilterInformation.setRegion((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketUserOsInterceptor) {
                    ticketFilterInformation.setUseros((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketUserAppInterceptor) {
                    ticketFilterInformation.setUserapp((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketPositionInterceptor) {
                    ticketFilterInformation.setPosition((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketTimesInterceptor) {
                    ticketFilterInformation.setTimes((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketUserGradeInterceptor) {
                    ticketFilterInformation.setUsergrade((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof TicketPositionGroupInterceptor) {
                    ticketFilterInformation.setPositiongroup((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (interceptor instanceof BudgetOfDailyInterceptor) {
                    ticketFilterInformation.setDailybudget((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
                    continue;
                }
                if (!(interceptor instanceof MediaTagInterceptor)) continue;
                ticketFilterInformation.setMediatag((String)ticketList.stream().reduce((ticketIdFirst, ticketIdSecond) -> ticketIdFirst + "," + ticketIdSecond).get());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5c06\u8fc7\u6ee4\u7684\u4fe1\u606f\u62fc\u88c5\u6210\u5bf9\u8c61\uff0c\u63d0\u4f9b\u6d88\u606f\u53d1\u9001\u51fa\u9519", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8fc7\u6ee4\u7684\u4fe1\u606f\u62fc\u88c5\u7ed3\u679c {}", (Object)ticketFilterInformation);
        }
        return ticketFilterInformation;
    }
}

