/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.scene;

import com.bxm.adsprod.service.ticket.scene.SceneService;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class SceneServiceFactory
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Map<Integer, SceneService> SNECES = Maps.newConcurrentMap();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext.getParent() == null) {
            Map beansOfType = applicationContext.getBeansOfType(SceneService.class);
            if (null == beansOfType) {
                return;
            }
            Set entries = beansOfType.entrySet();
            for (Map.Entry entry : entries) {
                SceneService service = (SceneService)entry.getValue();
                SNECES.put(service.getSceneType(), service);
            }
        }
    }

    public static SceneService getSceneService(int scene) {
        return SNECES.get(scene);
    }

    public static Map<Integer, SceneService> getScenes() {
        return Collections.unmodifiableMap(SNECES);
    }
}

