/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.scene.normal;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.TicketWeightService;
import com.bxm.adsprod.service.ticket.scene.SceneService;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultSceneServiceImpl
implements SceneService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSceneServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private UserService userService;
    @Autowired
    private TicketWeightService ticketWeightService;

    @Override
    public int getSceneType() {
        return 0;
    }

    @Override
    public List<TicketCache> getTickets(TicketRequest ticketRequest) {
        return this.getAvailableTickets();
    }

    private List<TicketCache> getAvailableTickets() {
        Map hfetchall = this.fetcher.hfetchall(TicketKeyGenerator.getAvailableTickets(), null, TicketCache.class);
        if (MapUtils.isEmpty((Map)hfetchall)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(hfetchall.values());
    }

    @Override
    public TicketCache getBestOne(TicketRequest ticketRequest, List<TicketCache> tickets) {
        String uid = ticketRequest.getUid();
        String positionId = ticketRequest.getPosition();
        Ticket lastAcquiredTicket = this.userService.getLastAcquiredTicket(uid);
        TicketCache best = this.ticketWeightService.getBest(tickets, uid, lastAcquiredTicket, positionId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6839\u636e\u6743\u91cd\u6700\u7ec8\u83b7\u5f97\u5e7f\u544a\u5238\uff1a{}", (Object)best);
        }
        return best;
    }
}

