/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.ticket.scene.popup;

import com.bxm.adsprod.facade.ticket.TicketCache;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketRequest;
import com.bxm.adsprod.facade.ticket.scene.TicketScene;
import com.bxm.adsprod.service.ticket.scene.SceneService;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PopupSceneServiceImpl
implements SceneService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PopupSceneServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public int getSceneType() {
        return 1;
    }

    @Override
    public List<TicketCache> getTickets(TicketRequest ticketRequest) {
        String uid = ticketRequest.getUid();
        String position = ticketRequest.getPosition();
        List scenes = this.fetcher.hfetchList(TicketKeyGenerator.Scene.getScene((int)1), position, null, TicketScene.class);
        if (CollectionUtils.isEmpty((Collection)scenes)) {
            return null;
        }
        ArrayList caches = Lists.newArrayList();
        for (TicketScene scene : scenes) {
            TicketCache cache;
            Set alreadys = (Set)this.fetcher.fetch(TicketKeyGenerator.Scene.getSceneViews((int)1, (String)uid), null, Set.class);
            if (CollectionUtils.isNotEmpty((Collection)alreadys) && alreadys.contains(String.valueOf(scene.getTicketid())) || null == (cache = (TicketCache)this.fetcher.hfetch(TicketKeyGenerator.getAvailableTickets(), String.valueOf(scene.getTicketid()), null, TicketCache.class))) continue;
            cache.setSequence(scene.getSequence());
            caches.add(cache);
        }
        return caches;
    }

    @Override
    public TicketCache getBestOne(TicketRequest ticketRequest, List<TicketCache> tickets) {
        if (CollectionUtils.isEmpty(tickets)) {
            return null;
        }
        tickets.sort((o1, o2) -> {
            Integer o1s = o1.getSequence();
            Integer o2s = o2.getSequence();
            return Integer.compare(null == o1s ? 0 : o1s, null == o2s ? 0 : o2s);
        });
        return tickets.get(0);
    }
}

