/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.user.NotEnoughTimesException;
import com.bxm.adsprod.service.user.UserAwardTimesService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.DefaultValTrackable;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.ValueOutOfLimitException;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UserAwardTimesServiceImpl
implements UserAwardTimesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAwardTimesServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="jedisCounter")
    private Counter counter;

    @Override
    public long decrementAndGet(final String uid, final String positionId, final BigInteger activityId) throws NotEnoughTimesException {
        KeyGenerator keyGenerator = new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "ACTIVITY", activityId, positionId, uid});
            }
        };
        try {
            Long count = this.counter.decrementAndGet(keyGenerator, new DefaultValTrackable(){

                public long getDefaultVal() {
                    Object activity = null;
                    if (null == activity) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Invalid activity: {}", (Object)activityId);
                        }
                        return 0L;
                    }
                    return activity.getAwardTimes().intValue();
                }
            }, 0L, TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday()).intValue());
            return count;
        }
        catch (ValueOutOfLimitException | IllegalStateException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("decrementAndGet:", e);
            }
            return 0L;
        }
    }
}

