/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.service.commons.configure.ActivityConfiguration;
import com.bxm.adsprod.service.commons.configure.AdsProdConfiguration;
import com.bxm.adsprod.service.user.UserService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AdsProdConfiguration.class})
public class UserServiceImpl
implements UserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private final ActivityConfiguration configuration;
    private final int activityDb;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public UserServiceImpl(AdsProdConfiguration adsProdConfiguration) {
        this.configuration = adsProdConfiguration.getActivity();
        this.activityDb = this.configuration.getDb();
    }

    @Override
    public Ticket getLastAcquiredTicket(String uid) {
        return (Ticket)this.fetcher.fetch(TicketKeyGenerator.User.getUser((String)uid), null, Ticket.class);
    }

    @Override
    public void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("inspectors is null.");
            }
            return;
        }
        if (StringUtils.isBlank((String)uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        this.updater.updateWithSelector(TicketKeyGenerator.User.getUser((String)uid), (Object)ticket, TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday()).intValue());
    }

    @Override
    public Set<Integer> getUserActRecord(String uid) {
        try {
            KeyGenerator userActKey = ActivityKeyGenerator.User.getUserActRecord((String)uid);
            Set actIds = (Set)this.fetcher.fetchWithSelector(userActKey, Set.class, this.activityDb);
            actIds = actIds != null ? actIds : Sets.newHashSet();
            return actIds;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55ERROR", (Throwable)e);
            return new HashSet<Integer>();
        }
    }

    @Override
    public void saveUserActRecord(String uid, Set<Integer> record) {
        try {
            KeyGenerator userActKey = ActivityKeyGenerator.User.getUserActRecord((String)uid);
            this.updater.updateWithSelector(userActKey, record, TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday()).intValue(), this.activityDb);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7528\u6237\u6d3b\u52a8\u53c2\u4e0e\u8bb0\u5f55ERROR", (Throwable)e);
        }
    }
}

