package com.bxm.adsprod.timer.jobs;

import com.bxm.adsprod.convert.media.PositionConvert;
import com.bxm.adsprod.dal.media.PositionMapper;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.dao.media.PositionDao;
import com.bxm.adsprod.timer.Job;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <h3>Positoin data pull job</h3>
 *
 * @author allen
 * @since V1.0.0 2018/01/04
 */
@Component
public class PositionDataPullJob implements Job {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionDataPullJob.class);

    @Autowired
    private PositionMapper positionMapper;
    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    @Scheduled(initialDelay = 1000, fixedDelay = 5 * 60 * 1000)
    public void execute() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting pull positions...");
        }

        long start = System.currentTimeMillis();

        List<PositionDao> positions = positionMapper.selectAll();

        for (PositionDao position : positions) {
            KeyGenerator keyGenerator = TicketKeyGenerator.Media.getPositions();
            updater.hupdate(keyGenerator, position.getPositionId(), PositionConvert.of(position));
        }

        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Pull finished in {} ms!", (System.currentTimeMillis() - start));
        }
    }
}
