package com.bxm.adx.facade.model.position;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * sdk配置请求类<br/>
 *
 * @author zhengwangeng
 * @date 2020/7/1 15:03
 */
@Data
public class SdkConfigRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位ID
     */
    @NotBlank(message = "广告位ID不能为空")
    private String positionId;

    /**
     * 广告位场景
     */
    @NotNull(message = "广告位场景不能为空")
    private Byte positionScene;

    /**
     * 是否是调试，调试只返回变现猫的数据
     */
    private Boolean isDebug;

    /**
     * sdk版本号
     */
    private String sdkv;

    /**
     * 系统类型，1：安卓，2：IOS
     */
    private Integer os;


    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * IMEI，所属安卓
     */
    private String imei_md5;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 安卓ID
     */
    private String anid_md5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     */
    private String idfa_md5;
    /**
     * appid
     */
    private String appId;
    /**
     * app包名
     */
    private String packageName;

}
