package com.bxm.adx.facade.constant.enums;

import java.util.Objects;

/**
 * 开发者应用平台类型<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/10 11:40
 */
public enum AppPlatformTypeEnum {

    /** 未知 */
    UNKOWN(0, "未知"),
    /** IOS */
    IOS(1, "IOS"),
    /** 安卓 */
    ANDROID(2, "安卓"),
    /** H5 */
    H5(3, "H5"),
    /** PC */
    PC(4, "PC"),
    ;
    
    /**
     * 系统类型
     */
    private int id;
    /**
     * 描述
     */
    private String desc;
    
    private AppPlatformTypeEnum(int id, String desc){
        this.id = id;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据原值返回枚举
     * @param id 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain AppPlatformTypeEnum.UNKOWN}
     */
    public static AppPlatformTypeEnum of(Integer id) {
        AppPlatformTypeEnum[] values = values();
        for (AppPlatformTypeEnum value : values) {
            if (Objects.equals(value.id, id)) {
                return value;
            }
        }
        return UNKOWN;
    }

    /**
     * 系统类型转平台类型
     * @param os 系统类型 0：未知 1：安卓 2：IOS
     * @return
     */
    public static AppPlatformTypeEnum convert(Integer os){
        if(os == null){
            return UNKOWN;
        }
        if(1 == os){
            return ANDROID;
        }else if(2 == os){
            return IOS;
        }else{
            return UNKOWN;
        }
    }
}
