package com.bxm.adx.facade.rule.task;

import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * 投放时段<br/>
 *
 * <pre>
 *     {timeDecimal},{timeDecimal},{timeDecimal}...
 *
 *     {timeDecimal} => 依次代表周一到周日的时段选中情况。
 *     值为24位的十进制数字,每个位的值代表一个小时的选中情况，
 *     全选中的二进制值为"111111111111111111111111", 转为十进制值"16777215"
 * </pre>
 *
 * @author kerry.jiang
 * @date 2020/7/13 14:11
 */
public class TaskTimeSlotRuleSo extends RuleSo {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTimeSlotRuleSo.class);

    //最少可分割成7份（周一到周日）
    private static final int VALUE_SPLIT_SIZE = 7;
    //投放时段的二进制位数
    private static final int BINARY_BIT = 24;
    //二进制位补“0”
    private static final String BINARY_ZERO = "0";

    /**
     * 时间段。星期几（0~6） -> 小时段（0~23） -> 是否可用
     */
    @JSONField(deserialize = false, serialize = false)
    private Map<Integer, Map<Integer, Boolean>> weekTimeSlot = new HashMap<>();

    public Map<Integer, Map<Integer, Boolean>> getWeekTimeSlot() {
        return weekTimeSlot;
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();
        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] dayTimeArray = StringUtils.split(value, ',');
        if (dayTimeArray.length < VALUE_SPLIT_SIZE) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid value format of 'TaskTimeSlotRuleSo', {}.", value);
            }
            return;
        }
        int dayIndex = -1;
        for (String dayTime : dayTimeArray){
            dayIndex ++;

            Map<Integer, Boolean> timeSlot = weekTimeSlot.get(dayIndex);
            if(null == timeSlot){
                timeSlot = new HashMap<>();
                weekTimeSlot.put(dayIndex, timeSlot);
            }

            //获取二进制字符串，空缺位补“0”
            Long timeDecimal = Long.valueOf(dayTime);
            String binary = Long.toBinaryString(timeDecimal);
            int repairNum = BINARY_BIT - binary.length();
            if(repairNum > 0){
                StringBuilder binaryBuilder = new StringBuilder();
                for (int i = 0 ; i < repairNum; i++){
                    binaryBuilder.append(BINARY_ZERO);
                }
                binaryBuilder.append(binary);
                binary = binaryBuilder.toString();
            }

            //绘制小时段映射值
            char[] chars = binary.toCharArray();
            int hourIndex = -1;
            for (char c : chars) {
                hourIndex ++;

                timeSlot.put(hourIndex, c == '1');
            }
        }
    }
}
