package com.bxm.adx.common;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author allen
 * @since 2019-12-12
 */
@Data
@ConfigurationProperties(prefix = "adx")
public class AdxProperties {

    /**
     * 买方竞价超时时间，单位：毫秒。默认：100
     */
    private int buyerBiddingTimeOutInMillis = 1000;

    /**
     * 并发买方竞价超时时间，单位：毫秒。默认：200
     */
    private int buyerConcurrentBiddingTimeOutInMillis = 200;

    private String counterBaseUrl;
}
