package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.builder.Interpreter;
import com.bxm.adx.common.buy.dispatcher.DispatcherDao;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.utils.AdxDecrypt;
import com.bxm.adx.common.utils.UrlUtils;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.req.Ad;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.adx.common.sell.ssp.req.Device;
import com.bxm.adx.common.sell.ssp.req.Screen;
import com.bxm.adx.common.sell.ssp.resp.*;
import com.bxm.adx.common.sell.ssp.resp.Asset;
import com.bxm.adx.common.sell.ssp.resp.Image;
import com.bxm.adx.common.sell.ssp.resp.Native;
import com.bxm.adx.common.sell.ssp.resp.Text;
import com.bxm.adx.common.sell.ssp.resp.Video;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2020/1/16.
 */
@Slf4j
public class BxmSspBidModelAdapter implements BidModelAdapter {

    @Resource
    private Interpreter interpreter;

    @Override
    public BidRequest convert(byte[] bytes) {
        SspRequest sspRequest = JsonHelper.convert(bytes, SspRequest.class);
        BidRequest request = interpreter.translate(sspRequest);
        if (log.isDebugEnabled()) {
            log.debug("bidrequest={}", JsonHelper.convert(request));
        }
        return request;
    }

    @Override
    public byte[] convert(BidResponse e, BidRequest bidRequest) {
        if (log.isDebugEnabled()) {
            log.debug("bidresponse={}", JsonHelper.convert(e));
        }
        SspResponse sspResponse = interpreter.translate(e, bidRequest);
        return JsonHelper.convert2bytes(sspResponse);
    }
}
