package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.*;
import com.bxm.adx.common.sell.ssp.resp.*;
import com.bxm.adx.common.utils.UrlUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;

import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class ConcreteSspResponseBuilder extends SspResponseBuilder {

    private AdxProperties properties;
    private PositionService positionService;

    public ConcreteSspResponseBuilder(AdxProperties properties, PositionService positionService) {
        this.properties = properties;
        this.positionService = positionService;
    }

    @Override
    public void buildResult(BidResponse response) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;

        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "无";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest) {
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        String ip = "";
        if (null != bidRequest) {
            Device device = bidRequest.getDevice();
            if (null != device) {
                ip = device.getIp();
            }
        }
        String time = System.currentTimeMillis() + "";
        String url = properties.getCounterBaseUrl();
        List<com.bxm.adx.common.sell.ssp.resp.Ad> ads = new ArrayList<>(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            for (Bid bid : bids) {
                com.bxm.adx.common.sell.ssp.resp.Ad ad = new com.bxm.adx.common.sell.ssp.resp.Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric(8));
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                // FIXME: 2020/3/5 只需要是信息流素材时
                Position position = positionService.getByPositionId(ad.getPlace_token());
                if (null != position) {
                    if (null != position.getInformationFlowTemplate())
                        ad.setTemplate(position.getInformationFlowTemplate());
                }

                ad.setDeeplink_url(bid.getDeep_link_url());
                if (ad.getAction() != 6) {
                    ad.setAppTracker(fillAppTracker(bid, url, e, time, seatBid, ip));
                }
                ad.setTarget_url(bid.getClick_through_url());
                List<ClickMonitor> clickMonitors = bid.getClick_monitors();
                List<String> curls = null;
                if (!CollectionUtils.isEmpty(clickMonitors)) {
                    curls = clickMonitors.stream().map(ClickMonitor::getClick_monitor_url).collect(Collectors.toList());

                }
                if (null == curls) {
                    curls = new ArrayList<>();
                }
                curls.add(UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "2", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
                ad.setClick_trackers(curls);
                List<ImpMonitor> impMonitors = bid.getImp_monitors();
                List<String> iurls = null;
                if (!CollectionUtils.isEmpty(impMonitors)) {
                    iurls = impMonitors.stream().map(ImpMonitor::getImp_monitor_url).collect(Collectors.toList());
                }
                if (null == iurls) {
                    iurls = new ArrayList<>();
                }
                String iurl = UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "1", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene());
                iurl = iurl + "&win="+ bid.getPrice_str();

                iurls.add(iurl);
                ad.setImp_trackers(iurls);
                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                com.bxm.adx.common.sell.ssp.resp.Native an = new com.bxm.adx.common.sell.ssp.resp.Native();
                List<com.bxm.adx.common.sell.ssp.resp.Asset> assets = new ArrayList<>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                List<com.bxm.adx.common.sell.response.Asset> snAssets = sn.getAssets();
                for (com.bxm.adx.common.sell.response.Asset sa : snAssets) {
                    com.bxm.adx.common.sell.ssp.resp.Asset asset = new com.bxm.adx.common.sell.ssp.resp.Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    switch (sa.getType()) {
                        case 1:
                            com.bxm.adx.common.sell.ssp.resp.Text title = new com.bxm.adx.common.sell.ssp.resp.Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        case 2:
                            com.bxm.adx.common.sell.ssp.resp.Text content = new com.bxm.adx.common.sell.ssp.resp.Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        case 3:
                            com.bxm.adx.common.sell.ssp.resp.Text buttonText = new com.bxm.adx.common.sell.ssp.resp.Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        case 6:
                            com.bxm.adx.common.sell.ssp.resp.Image image = new com.bxm.adx.common.sell.ssp.resp.Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            asset.setImg(image);
                            break;
                        case 7:
                            com.bxm.adx.common.sell.ssp.resp.Image limg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            asset.setImg(limg);
                            break;
                        case 8:
                            com.bxm.adx.common.sell.ssp.resp.Image bimg = new com.bxm.adx.common.sell.ssp.resp.Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            asset.setImg(bimg);
                            break;
                        case 12:
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            com.bxm.adx.common.sell.response.Video v = sa.getVideo();
                            BeanUtils.copyProperties(v, video);

                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties(v.getV_monitor(), vm);
                            }

                            video.setV_monitor(fillVMonitor(vm, url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
                            asset.setVideo(video);
                            break;
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);
                ads.add(ad);
            }
        }
        sspResponse.setAds(ads);
    }

    private AppTracker fillAppTracker (Bid bid, String url, BidResponse e, String time, SeatBid seatBid, String ip) {
        AppMonitor appMonitor = bid.getApp_monitor();

        AppTracker appTracker = new AppTracker();
        List<String> dfUrls = appMonitor == null ? null : appMonitor.getDf_urls();
        if (null == dfUrls) {
            dfUrls = new ArrayList<>();
        }
        dfUrls.add(UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "14", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
        appTracker.setDf_urls(dfUrls);

        List<String> dsUrls = appMonitor == null ? null : appMonitor.getDs_urls();
        if (null == dsUrls) {
            dsUrls = new ArrayList<>();
        }
        dsUrls.add(UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "13", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
        appTracker.setDs_urls(dsUrls);

        List<String> ssUrls = appMonitor == null ? null : appMonitor.getSs_urls();
        if (null == ssUrls) {
            ssUrls = new ArrayList<>();
        }
        ssUrls.add(UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "15", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
        appTracker.setSs_urls(ssUrls);

        List<String> sfUrls = appMonitor == null ? null : appMonitor.getSf_urls();
        if (null == sfUrls) {
            sfUrls = new ArrayList<>();
        }
        sfUrls.add(UrlUtils.convertParam(url, e.getId(), time, bid.getTag_id(), bid.getCreate_id(), "16", seatBid.getDspId().toString(), ip, bid.getAct_id(), bid.getScene()));
        appTracker.setSf_urls(sfUrls);
        return appTracker;
    }

    private VMonitor fillVMonitor(VMonitor vm, String url, String bid, String time, String tagId, String creativeId, String dspId, String ip, String actId, String scene) {
        List<String> vCloseUrls = vm.getV_close_urls();
        if (null == vCloseUrls) {
            vCloseUrls = new ArrayList<>();
        }
        vCloseUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "10", dspId, ip, actId, scene));
        vm.setV_close_urls(vCloseUrls);

        List<String> vEndUrls = vm.getV_end_urls();
        if (null == vEndUrls) {
            vEndUrls = new ArrayList<>();
        }
        vEndUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "7", dspId, ip, actId, scene));
        vm.setV_end_urls(vEndUrls);

        List<String> vHalfUrls = vm.getV_half_urls();
        if (null == vHalfUrls) {
            vHalfUrls = new ArrayList<>();
        }
        vHalfUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "5", dspId, ip, actId, scene));
        vm.setV_half_urls(vHalfUrls);

        List<String> vMuteUrls = vm.getV_mute_urls();
        if (null == vMuteUrls) {
            vMuteUrls = new ArrayList<>();
        }
        vMuteUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "8", dspId, ip, actId, scene));
        vm.setV_mute_urls(vMuteUrls);

        List<String> vProceedUrls = vm.getV_proceed_urls();
        if (null == vProceedUrls) {
            vProceedUrls = new ArrayList<>();
        }
        vProceedUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "12", dspId, ip, actId, scene));
        vm.setV_proceed_urls(vProceedUrls);

        List<String> vQuarterUrls = vm.getV_quarter_urls();
        if (null == vQuarterUrls) {
            vQuarterUrls = new ArrayList<>();
        }
        vQuarterUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "4", dspId, ip, actId, scene));
        vm.setV_quarter_urls(vQuarterUrls);

        List<String> vSkipUrls = vm.getV_skip_urls();
        if (null == vSkipUrls) {
            vSkipUrls = new ArrayList<>();
        }
        vSkipUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "9", dspId, ip, actId, scene));
        vm.setV_skip_urls(vSkipUrls);

        List<String> vStartUrls = vm.getV_start_urls();
        if (null == vStartUrls) {
            vStartUrls = new ArrayList<>();
        }
        vStartUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "3", dspId, ip, actId, scene));
        vm.setV_start_urls(vStartUrls);

        List<String> vSuspendUrls = vm.getV_suspend_urls();
        if (null == vSuspendUrls) {
            vSuspendUrls = new ArrayList<>();
        }
        vSuspendUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "11", dspId, ip, actId, scene));
        vm.setV_suspend_urls(vSuspendUrls);

        List<String> vThreeQuarterUrls = vm.getV_three_quarter_urls();
        if (null == vThreeQuarterUrls) {
            vThreeQuarterUrls = new ArrayList<>();
        }
        vThreeQuarterUrls.add(UrlUtils.convertParam(url, bid, time, tagId, creativeId, "6", dspId, ip, actId, scene));
        vm.setV_three_quarter_urls(vThreeQuarterUrls);

        return vm;
    }
}
