package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.SspResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * Created by Arei on 2020/4/10.
 */
@Component
@Slf4j
public class Interpreter {

    private AdxRequestBuilder adxRequestBuilder;

    private SspResponseBuilder sspResponseBuilder;

    public Interpreter(AdxRequestBuilder adxRequestBuilder, SspResponseBuilder sspResponseBuilder) {
        this.adxRequestBuilder = adxRequestBuilder;
        this.sspResponseBuilder = sspResponseBuilder;
    }

    public BidRequest translate(SspRequest sspRequest) {

        adxRequestBuilder.buildId(sspRequest);
        adxRequestBuilder.buildAdxType(sspRequest);
        adxRequestBuilder.buildImps(sspRequest);
        adxRequestBuilder.buildcType(sspRequest);
        adxRequestBuilder.buildApp(sspRequest);
        adxRequestBuilder.buildDevice(sspRequest);
        adxRequestBuilder.buildUser(sspRequest);
        adxRequestBuilder.buildGeo(sspRequest);
        adxRequestBuilder.buildCur(sspRequest);
        adxRequestBuilder.buildBidType(sspRequest);
        adxRequestBuilder.buildAt(sspRequest);
        adxRequestBuilder.buildDealIds(sspRequest);
        adxRequestBuilder.buildBillType(sspRequest);
        adxRequestBuilder.buildTest(sspRequest);
        adxRequestBuilder.buildtMax(sspRequest);
        adxRequestBuilder.buildbCat(sspRequest);
        adxRequestBuilder.buildbSeat(sspRequest);
        adxRequestBuilder.buildwSeat(sspRequest);
        adxRequestBuilder.buildbAdv(sspRequest);
        adxRequestBuilder.buildbApp(sspRequest);
        adxRequestBuilder.buildExt(sspRequest);
        adxRequestBuilder.buildAdType(sspRequest);

        return adxRequestBuilder.getRequest();
    }

    public SspResponse translate(BidResponse bidResponse, BidRequest bidRequest) {

        sspResponseBuilder.buildResult(bidResponse);
        sspResponseBuilder.buildMsg(bidResponse);
        sspResponseBuilder.buildAds(bidResponse, bidRequest);

        return sspResponseBuilder.getSspResponse();
    }
}
