package com.bxm.adx.common.buy;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.dsp.Dsp;

/**
 * 购买流量
 *
 * @author allen
 * @since 2019-12-12
 */
public interface Buyer {

    /**
     * @return DSP
     */
    Dsp getDsp();

    /**
     * 买方名称，需要唯一。(平台唯一标识)
     *
     * @return 名称
     */
    String getCode();

    /**
     * 返回这个买家的模型适配器
     *
     * @return 模型适配器
     */
    BuyModelAdapter getModelAdapter();

    /**
     * 出价
     * @param request 请求
     * @return 结果
     */
    byte[] offer(byte[] request);
}
