package com.bxm.adx.common.buy.dsp;

import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * @author allen
 * @since 2019-12-16
 */
@Configuration
public class DspServiceImpl implements DspService {

    private final DspDao dspDao;

    public DspServiceImpl(DspDao dspDao) {
        this.dspDao = dspDao;
    }

    @Override
    public Dsp get(Long id) {
        Collection<Dsp> dsps = dspDao.getAll();
        for (Dsp dsp : dsps) {
            if (dsp.getId().equals(id)) {
                return dsp;
            }
        }
        return null;
    }

    @Override
    public Dsp get(String dspCode) {
        Collection<Dsp> dsps = dspDao.getAll();
        for (Dsp dsp : dsps) {
            if (dsp.getDspCode().equals(dspCode)) {
                return dsp;
            }
        }
        return null;
    }
}
