package com.bxm.adx.common.market;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import com.bxm.adx.common.market.exchange.PriorityExchanger;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.revealbottom.RevealBottom;
import com.bxm.adx.common.sell.BidResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * RTB 竞价市场，支持优先级批次竞价。
 *
 * @author allen
 * @since 2019-12-16
 */
@Slf4j
@Primary
@Configuration
public class DefaultMarketImpl implements Market {

    private final PriorityExchanger priorityExchanger;
    private final Filter filter;
    private final RevealBottom revealBottom;

    public DefaultMarketImpl(PriorityExchanger priorityExchanger, Filter filter, RevealBottom revealBottom) {
        this.priorityExchanger = priorityExchanger;
        this.filter = filter;
        this.revealBottom = revealBottom;
    }

    @Override
    public BidResponse exchange(MarketOrders orders) {
        List<Deal> deals = priorityExchanger.exchange(orders);
        if (CollectionUtils.isNotEmpty(deals)) {
            filter.filter(deals);
        }else{
            //兜底
            deals = revealBottom.exchange(orders);
            if (CollectionUtils.isEmpty(deals)) {
                return null;
            }
        }
        return DealWrapper.merge(deals);
    }
}
