package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import java.util.List;
import java.util.Map;

/**
 * 低价过滤器，同一个广告位只保留出价最高的。
 *
 * @author allen
 * @since 2019-12-18
 */
@Order(Ordered.LOWEST_PRECEDENCE)
@Slf4j
@Configuration
public class PriceLowerFilter implements Filter {

    @Override
    public void filter(List<Deal> deals) {
        Map<String, Float> higher = Maps.newHashMap();
        deals.removeIf(deal -> {
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                return true;
            }
            List<SeatBid> seatBid = response.getSeat_bid();
            if (CollectionUtils.isEmpty(seatBid)) {
                return true;
            }
            seatBid.removeIf(bid -> {
                List<Bid> bidList = bid.getBid();
                if (CollectionUtils.isEmpty(bidList)) {
                    return true;
                }
                bidList.removeIf(b -> {
                    String imp_id = b.getImp_id();
                    Float price = b.getPrice();
                    if (null == price) {
                        return true;
                    }
                    Float max = MapHelper.get(higher, imp_id, price);
                    if (price.compareTo(max) > 0) {
                        higher.put(imp_id, price);
                        return true;
                    }
                    return false;
                });
                return CollectionUtils.isEmpty(bidList);
            });
            return CollectionUtils.isEmpty(seatBid);
        });
    }
}
