package com.bxm.adx.common.sdkconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

/**
 * <p>
 * 广告位SDK配置服务实现
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-7
 */
@Configuration
public class SdkConfigServiceImpl implements SdkConfigService {
    
    private final static String CHAN_BXM = "bxm_channel";

    private final SdkConfigDao sdkConfigDao;

    public SdkConfigServiceImpl(SdkConfigDao sdkConfigDao) {
        this.sdkConfigDao = sdkConfigDao;
    }

    @Override
    public List<SdkConfig> getByPositionId(String positionId, Boolean isDebug) {
        List<SdkConfig> sdkConfigs = sdkConfigDao.getByPositionId(positionId);
        if(Boolean.TRUE.equals(isDebug)){
            return getSdkConfigsForDebug(sdkConfigs);
        }else{
            return sdkConfigs;
        }
    }

    /**
     * 获取debug数据
     */
    private List<SdkConfig> getSdkConfigsForDebug(List<SdkConfig> sdkConfigs) {
        if(CollectionUtils.isEmpty(sdkConfigs)){
            return Collections.emptyList();
        }
        List<SdkConfig> resps = new ArrayList<>();
        for (SdkConfig conf : sdkConfigs) {
            if(!Objects.equals(CHAN_BXM, conf.getChannelType())){
                continue;
            }
            resps.add(conf);
        }
        return resps;
    }
}
