package com.bxm.adx.common.sell.position;

import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 2019-12-18
 */
@Configuration
public class PositionServiceImpl implements PositionService {

    private final PositionDao positionDao;

    public PositionServiceImpl(PositionDao positionDao) {
        this.positionDao = positionDao;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        //TODO 这里有可能传的是appPositionId
        Position position = positionDao.getByPositionId(positionId);
        if (position == null) {
            position = getByAppPositionId(positionId);
        }
        return position;
    }
}
