package com.bxm.adx.common.sell.position.dsp;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.ToString;

/**
 * 广告位场景设置。</br>
 * Created by zhengwangeng on 2020/5/28 11:29.
 */
@Data
@ToString
public class SceneSetting implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    /**
     * 互动激励视频
     */
    public static final int SCENE_TYPE_INSPIRE_VIDEO = 1;
    /**
     * 变现百宝箱
     */
    public static final int SCENE_TYPE_BBX = 2;
    /**
     * 互动广告
     */
    public static final int SCENE_TYPE_INTERACT = 3;

    /**
     * 广告位Id
     */
    private String positionId;

    /**
     * 场景类型
     */
    private Integer sceneType;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 激励视频广告位
     */
    private String inspireVideoPositionId;

    /**
     * H5链接：互动广告和变现百宝箱，配置内容和互动广告相同，都需要配置该属性
     */
    private String h5Url;

    /**
     * 媒体入口素材
     */
    private List<MediaEntranceCreative> mediaEntranceCreatives;


}

