package com.bxm.adx.common.sell.position.dsp;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;

/**
 *
 * For cache pushable
 *
 * <pre>
 * name = "POSITION"
 * parameters = {positionId=$positionId}
 * byte[] = SceneSetting object to json bytes
 * </pre>
 * @author zhengwangeng
 * @since 2020-5-28
 */
@CachePush("SCENE_SETTING")
@Component
@Slf4j
public class SceneSettingDaoImpl implements SceneSettingDao, Pushable {

    private final Fetcher fetcher;
    private final Updater updater;

    public SceneSettingDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public SceneSetting getByPositionId(String positionId) {
        return fetcher.fetch(getKeyGenerator(positionId), SceneSetting.class);
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isWarnEnabled()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                log.warn("k = {} , v = {}", entry.getKey(), entry.getValue());
            }
        }
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        SceneSetting sceneSetting = JsonHelper.convert(data, SceneSetting.class);
        if (log.isWarnEnabled()) {
            log.warn("sceneSetting = {}", sceneSetting);
        }
        updater.remove(getKeyGenerator(positionId));

        updater.update(getKeyGenerator(sceneSetting.getPositionId()), sceneSetting);
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build("ADX", "POSITION", "SCENE", "DSP", value);
    }
}
