/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common;

import com.bxm.adx.common.AdxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={AdxException.class})
    @ResponseBody
    public ResponseEntity<String> handleException(AdxException ex) {
        if (log.isErrorEnabled()) {
            log.error(ex.getMessage());
        }
        ResponseEntity entity = new ResponseEntity(HttpStatus.resolve((int)ex.getCode()));
        return entity;
    }
}

