/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.builder.AdxRequestBuilder;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.Ad;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.adx.common.sell.ssp.req.Screen;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConcreteAdxRequestBuilder
extends AdxRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConcreteAdxRequestBuilder.class);
    private PositionService positionService;

    public ConcreteAdxRequestBuilder(PositionService positionService) {
        this.positionService = positionService;
    }

    @Override
    public void buildId(SspRequest sspRequest, BidRequest request) {
        request.setId(RandomStringUtils.randomAlphanumeric((int)8));
    }

    @Override
    public void buildAdxType(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildImps(SspRequest sspRequest, BidRequest request) {
        List<Ad> ads = sspRequest.getAds();
        if (log.isDebugEnabled()) {
            log.debug("adssize={}", (Object)ads.size());
        }
        ArrayList<Impression> impressions = new ArrayList<Impression>(ads.size());
        for (Ad ad : ads) {
            Impression i = new Impression();
            i.setId(RandomStringUtils.randomAlphanumeric((int)8));
            i.setTag_id(ad.getPlace_token());
            i.setW(ad.getW());
            i.setH(ad.getH());
            Position position = this.positionService.getByPositionId(ad.getPlace_token());
            if (null == position) {
                if (log.isErrorEnabled()) {
                    log.error("pos is null");
                }
                return;
            }
            this.positionService.verifyPosition(position, sspRequest);
            i.setType(AdxConstants.Type.getTypeByPositionScene(position.getPositionScene()));
            impressions.add(i);
        }
        if (log.isDebugEnabled()) {
            log.debug("impressionssize={}", (Object)impressions.size());
        }
        request.setImps(impressions);
    }

    @Override
    public void buildcType(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildApp(SspRequest sspRequest, BidRequest request) {
        App app = sspRequest.getApp();
        com.bxm.adx.common.sell.request.App a = new com.bxm.adx.common.sell.request.App();
        a.setId(RandomStringUtils.randomAlphanumeric((int)6));
        a.setName(app.getName());
        a.setBundle(app.getBundle());
        request.setApp(a);
    }

    @Override
    public void buildDevice(SspRequest sspRequest, BidRequest request) {
        com.bxm.adx.common.sell.ssp.req.Device device = sspRequest.getDevice();
        Device d = new Device();
        d.setUa(device.getUa());
        d.setIp(device.getIp());
        d.setImei(device.getImei());
        d.setImei_md5(device.getImei_md5());
        d.setIdfa(device.getIdfa());
        d.setIdfa_md5(device.getIdfa_md5());
        d.setDpid(device.getAndroid_id());
        d.setDpid_md5(device.getAndroid_id_md5());
        d.setMake(device.getMake());
        d.setModel(device.getModel());
        d.setOs(device.getOs());
        d.setOsv(device.getOs_version());
        d.setBrand(device.getBrand());
        d.setMac(device.getMac());
        Screen screen = device.getScreen();
        if (null != screen) {
            d.setW(screen.getW());
            d.setH(screen.getH());
            d.setDpi(screen.getDpi());
        }
        d.setConnection_type(1);
        d.setImsi("46003");
        request.setDevice(d);
    }

    @Override
    public void buildUser(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildGeo(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildCur(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildBidType(SspRequest sspRequest, BidRequest request) {
        request.setBid_type(1);
    }

    @Override
    public void buildAt(SspRequest sspRequest, BidRequest request) {
        request.setAt(1);
    }

    @Override
    public void buildDealIds(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildBillType(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildTest(SspRequest sspRequest, BidRequest request) {
        Integer test = sspRequest.getTest();
        request.setTest(null == test ? 0 : test);
    }

    @Override
    public void buildtMax(SspRequest sspRequest, BidRequest request) {
        request.setT_max(100);
    }

    @Override
    public void buildbCat(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildbSeat(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildwSeat(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildbAdv(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildbApp(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildExt(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildAdType(SspRequest sspRequest, BidRequest request) {
    }

    @Override
    public void buildSdkVer(SspRequest sspRequest, BidRequest request) {
        request.setSdk_ver(sspRequest.getVer());
    }
}

