/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.adapter.builder.MonitorBuilder;
import com.bxm.adx.common.adapter.builder.SspResponseBuilder;
import com.bxm.adx.common.entity.AdxCounterParam;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.adx.common.sell.response.Asset;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.sell.response.Video;
import com.bxm.adx.common.sell.ssp.SspResponse;
import com.bxm.adx.common.sell.ssp.resp.Ad;
import com.bxm.adx.common.sell.ssp.resp.Config;
import com.bxm.adx.common.sell.ssp.resp.Image;
import com.bxm.adx.common.sell.ssp.resp.Native;
import com.bxm.adx.common.sell.ssp.resp.Text;
import com.bxm.adx.common.sell.ssp.resp.VMonitor;
import com.bxm.warcar.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ConcreteSspResponseBuilder
extends SspResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConcreteSspResponseBuilder.class);
    private AdxProperties properties;
    private PositionService positionService;
    private MonitorBuilder monitorBuilder;

    public ConcreteSspResponseBuilder(AdxProperties properties, PositionService positionService, MonitorBuilder monitorBuilder) {
        this.properties = properties;
        this.positionService = positionService;
        this.monitorBuilder = monitorBuilder;
    }

    @Override
    public void buildResult(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        int result = 0;
        if (CollectionUtils.isEmpty(seatBids)) {
            result = -1;
        }
        sspResponse.setResult(result);
    }

    @Override
    public void buildMsg(BidResponse response, SspResponse sspResponse) {
        List<SeatBid> seatBids = response.getSeat_bid();
        String msg = "";
        if (CollectionUtils.isEmpty(seatBids)) {
            msg = "\u65e0";
        }
        sspResponse.setMsg(msg);
    }

    @Override
    public void buildAds(BidResponse e, BidRequest bidRequest, SspResponse sspResponse) {
        Device device;
        List<SeatBid> seatBids = e.getSeat_bid();
        if (CollectionUtils.isEmpty(seatBids)) {
            return;
        }
        AdxCounterParam param = null;
        if (null != bidRequest && null != (device = bidRequest.getDevice())) {
            String os = null;
            String osStr = device.getOs();
            if (!StringUtils.isEmpty((CharSequence)osStr)) {
                if ("ios".equalsIgnoreCase(osStr)) {
                    os = "2";
                }
                if ("android".equalsIgnoreCase(osStr)) {
                    os = "1";
                }
            }
            param = AdxCounterParam.builder().anid(device.getDpid()).anid_md5(device.getDpid_md5()).idfa(device.getIdfa()).idfa_md5(device.getIdfa_md5()).imei(device.getImei()).imei_md5(device.getImei_md5()).oaid(device.getOaid()).mac(device.getMac()).os(os).ip(device.getIp()).ua(device.getUa()).build();
        }
        String url = this.properties.getCounterBaseUrl();
        ArrayList<Ad> ads = new ArrayList<Ad>(seatBids.size());
        for (SeatBid seatBid : seatBids) {
            List<Bid> bids = seatBid.getBid();
            for (Bid bid : bids) {
                List<String> dpSuccessUrls;
                if (param == null) {
                    param = AdxCounterParam.builder().build();
                }
                param.setBidid(e.getId());
                param.setDspid(seatBid.getDspId().toString());
                param.setCreateid(bid.getCreate_id());
                param.setTagid(bid.getTag_id());
                param.setScene(bid.getScene());
                param.setWin(bid.getPrice_str());
                Ad ad = new Ad();
                ad.setId(RandomStringUtils.randomAlphanumeric((int)8));
                ad.setPlace_token(bid.getTag_id());
                ad.setAction(bid.getC_type());
                ad.setW(bid.getW());
                ad.setH(bid.getH());
                Position position = this.positionService.getByPositionId(ad.getPlace_token());
                Config config = new Config();
                ad.setConfig(config);
                config.setBoot_time(position.getBootTime());
                config.setClick_video_action(position.getClickVideoAction());
                config.setShow_ad_logo(position.getIsShowAdLogo());
                config.setShow_endpage(position.getIsShowEndpage());
                if (null != position && null != position.getInformationFlowTemplate()) {
                    ad.setTemplate(position.getInformationFlowTemplate());
                }
                ad.setClick_trackers(this.monitorBuilder.fillClickMonitor(bid.getClick_monitors(), url, param));
                ad.setImp_trackers(this.monitorBuilder.fillImpMonitor(bid.getImp_monitors(), url, param));
                ad.setDeeplink_url(bid.getDeep_link_url());
                if (StringUtils.isNotEmpty((CharSequence)bid.getDeep_link_url())) {
                    ad.setDp_tracker(this.monitorBuilder.fillDpMonitor(bid.getDpMonitor(), url, param));
                }
                if (!StringHelper.isNewVersion((String)"3.1.0", (String)bidRequest.getSdk_ver()) && null != ad.getDp_tracker() && !CollectionUtils.isEmpty(dpSuccessUrls = ad.getDp_tracker().getAwk_success_urls())) {
                    List<String> cts = ad.getClick_trackers();
                    if (!CollectionUtils.isEmpty(cts)) {
                        cts.addAll(dpSuccessUrls);
                    } else {
                        cts = dpSuccessUrls;
                    }
                    ad.setClick_trackers(cts);
                }
                if (ad.getAction() == 2 || ad.getAction() == 3 || ad.getAction() == 9 || ad.getAction() == 11) {
                    ad.setAppTracker(this.monitorBuilder.fillAppTracker(bid.getApp_monitor(), url, param));
                }
                ad.setTarget_url(bid.getClick_through_url());
                ad.setType(bid.getType());
                ad.setApk_name(bid.getApk_name());
                ad.setApp_bundle(bid.getBundle());
                Native an = new Native();
                ArrayList<com.bxm.adx.common.sell.ssp.resp.Asset> assets = new ArrayList<com.bxm.adx.common.sell.ssp.resp.Asset>();
                com.bxm.adx.common.sell.response.Native sn = bid.getA_native();
                List<Asset> snAssets = sn.getAssets();
                for (Asset sa : snAssets) {
                    com.bxm.adx.common.sell.ssp.resp.Asset asset = new com.bxm.adx.common.sell.ssp.resp.Asset();
                    asset.setType(sa.getType());
                    asset.setId(sa.getId());
                    asset.setRequired(sa.getRequired());
                    switch (sa.getType()) {
                        case 1: {
                            Text title = new Text();
                            title.setText(sa.getText().getText());
                            asset.setText(title);
                            break;
                        }
                        case 2: {
                            Text content = new Text();
                            content.setText(sa.getText().getText());
                            asset.setText(content);
                            break;
                        }
                        case 3: {
                            Text buttonText = new Text();
                            buttonText.setText(sa.getText().getText());
                            asset.setText(buttonText);
                            break;
                        }
                        case 6: {
                            Image image = new Image();
                            image.setUrl(sa.getImg().getUrl());
                            image.setH(sa.getImg().getH());
                            image.setW(sa.getImg().getW());
                            asset.setImg(image);
                            break;
                        }
                        case 7: {
                            Image limg = new Image();
                            limg.setUrl(sa.getImg().getUrl());
                            limg.setH(sa.getImg().getH());
                            limg.setW(sa.getImg().getW());
                            asset.setImg(limg);
                            break;
                        }
                        case 8: {
                            Image bimg = new Image();
                            bimg.setUrl(sa.getImg().getUrl());
                            bimg.setH(sa.getImg().getH());
                            bimg.setW(sa.getImg().getW());
                            asset.setImg(bimg);
                            break;
                        }
                        case 12: {
                            com.bxm.adx.common.sell.ssp.resp.Video video = new com.bxm.adx.common.sell.ssp.resp.Video();
                            Video v = sa.getVideo();
                            BeanUtils.copyProperties((Object)v, (Object)video);
                            VMonitor vm = new VMonitor();
                            if (null != v.getV_monitor()) {
                                BeanUtils.copyProperties((Object)v.getV_monitor(), (Object)vm);
                            }
                            video.setV_monitor(this.monitorBuilder.fillVMonitor(vm, url, param));
                            asset.setVideo(video);
                        }
                    }
                    assets.add(asset);
                }
                an.setAssets(assets);
                ad.setA_native(an);
                ads.add(ad);
            }
        }
        sspResponse.setAds(ads);
    }
}

