/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionDao;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class PositionServiceImpl
implements PositionService {
    private static final Logger log = LoggerFactory.getLogger(PositionServiceImpl.class);
    private final PositionDao positionDao;
    private final AppService appService;

    public PositionServiceImpl(PositionDao positionDao, AppService appService) {
        this.positionDao = positionDao;
        this.appService = appService;
    }

    @Override
    public Position getByAppPositionId(String appPositionId) {
        return this.positionDao.getByAppPositionId(appPositionId);
    }

    @Override
    public Position getByPositionId(String positionId) {
        Position position = this.positionDao.getByPositionId(positionId);
        if (position == null) {
            position = this.getByAppPositionId(positionId);
        }
        return position;
    }

    @Override
    public void verifyPosition(Position position, SspRequest sspRequest) {
        App app;
        String appId = null;
        String packageName = null;
        if (null != sspRequest && null != (app = sspRequest.getApp())) {
            packageName = app.getBundle();
        }
        if (StringUtils.isEmpty(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("app packageName is not exist");
            }
            return;
        }
        if (null != position) {
            appId = position.getAppId();
        }
        if (StringUtils.isEmpty(appId)) {
            if (log.isWarnEnabled()) {
                log.warn("app position is not exist");
            }
            return;
        }
        app = this.appService.getAppById(appId);
        if (null == app) {
            if (log.isWarnEnabled()) {
                log.warn("appId: {} is not exist", (Object)appId);
            }
        } else {
            String realPackName = app.getAppPackageName();
            if (StringUtils.isEmpty((Object)realPackName)) {
                if (log.isWarnEnabled()) {
                    log.warn("appId: {} realPackName is null", (Object)appId);
                }
            } else {
                if (realPackName.equalsIgnoreCase(packageName)) {
                    return;
                }
                if (log.isWarnEnabled()) {
                    String posId = position.getPositionId();
                    if (StringUtils.isEmpty((Object)posId)) {
                        posId = "-";
                    }
                    log.warn("verify err, pos={},real={},now={}", new Object[]{posId, realPackName, packageName});
                }
            }
        }
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return this.positionDao.getInteractByPositionId(positionId);
    }
}

