/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.dsp;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.common.sell.creatives.MediaEntranceCreativesBuider;
import com.bxm.adx.common.sell.position.dsp.SceneSettingDao;
import com.bxm.adx.common.utils.DateUtils;
import com.bxm.mccms.facade.model.pushable.SceneSettingCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@CachePush(value="SCENE_SETTING")
@Component
public class SceneSettingDaoImpl
implements SceneSettingDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(SceneSettingDaoImpl.class);
    private final Fetcher fetcher;
    private final Updater updater;

    public SceneSettingDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public SceneSettingCacheVO getByPositionId(String positionId) {
        return (SceneSettingCacheVO)this.fetcher.fetch(this.getKeyGenerator(positionId), SceneSettingCacheVO.class);
    }

    @Override
    public Map<Integer, String> getActivityIdByPosId(String positionId) {
        LocalDate now = LocalDate.now();
        String date = now.format(DateTimeFormatter.BASIC_ISO_DATE);
        String testActId = (String)this.fetcher.hfetch(this.getRelationTestKeyGenerator(positionId), date, String.class);
        String normalActId = (String)this.fetcher.hfetch(this.getRelationKeyGenerator(positionId), date, String.class);
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, normalActId);
        result.put(2, testActId);
        return result;
    }

    @Override
    public boolean isParticipate(String positionId, String uid, String activityId) {
        String aid = (String)this.fetcher.hfetch(this.getParticipateKeyGenerator(positionId), uid, String.class);
        if (StringUtils.isEmpty((Object)aid)) {
            return false;
        }
        return aid.equals(activityId);
    }

    @Override
    public void participate(String positionId, String uid, String activityId) {
        this.updater.hupdate(this.getParticipateKeyGenerator(positionId), uid, (Object)activityId);
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        Object o;
        if (log.isWarnEnabled()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                log.warn("k = {} , v = {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        if (Objects.isNull(o = parameters.get("positionId"))) {
            return;
        }
        String positionId = Objects.toString(o);
        SceneSettingCacheVO sceneSetting = (SceneSettingCacheVO)JsonHelper.convert((byte[])data, SceneSettingCacheVO.class);
        if (log.isWarnEnabled()) {
            log.warn("sceneSetting = {}", (Object)sceneSetting);
        }
        this.updater.remove(this.getKeyGenerator(positionId));
        this.updater.update(this.getKeyGenerator(sceneSetting.getPositionId()), (Object)sceneSetting);
        List creativeIds = sceneSetting.getMediaEntranceCreatives().stream().filter(SceneSettingCacheVO.MediaEntranceCreative::isOpen).map(SceneSettingCacheVO.MediaEntranceCreative::getCreativeId).collect(Collectors.toList());
        this.updater.hupdateWithSelector(MediaEntranceCreativesBuider.positionAllCreatives(), positionId, (Object)JSON.toJSONString(creativeIds), 2);
        this.handleActivity(positionId, sceneSetting.getSceneActivities());
    }

    private KeyGenerator getParticipateKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "PARTICIPATE", value});
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "DSP", value});
    }

    private KeyGenerator getRelationKeyGenerator(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "ACTIVITY", "RELATION", positionId});
    }

    private KeyGenerator getRelationTestKeyGenerator(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "POSITION", "SCENE", "ACTIVITY", "RELATION", "TEST", positionId});
    }

    private void handleActivity(String pid, List<SceneSettingCacheVO.SceneActivity> sceneActivities) {
        this.updater.remove(this.getRelationKeyGenerator(pid));
        this.updater.remove(this.getRelationTestKeyGenerator(pid));
        if (CollectionUtils.isEmpty(sceneActivities)) {
            return;
        }
        for (SceneSettingCacheVO.SceneActivity sa : sceneActivities) {
            if (sa.getOpened() == 0) continue;
            String aid = sa.getActivityId();
            LocalDate start = DateUtils.convertDate(sa.getStartDate());
            LocalDate end = DateUtils.convertDate(sa.getEndDate());
            Integer type = sa.getType();
            while (start.compareTo(end) <= 0) {
                String date = start.format(DateTimeFormatter.BASIC_ISO_DATE);
                if (1 == type) {
                    this.updater.hupdate(this.getRelationKeyGenerator(pid), date, (Object)aid);
                } else {
                    this.updater.hupdate(this.getRelationTestKeyGenerator(pid), date, (Object)aid);
                }
                start = start.plusDays(1L);
            }
        }
    }
}

