package com.bxm.adx.common.filter;

import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>广告位抽象过滤器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/20 16:32
 */

@Slf4j
public abstract class AbstractPositionFilter implements Filter {

    public AbstractPositionFilter() {
    }

    @Override
    public void filter(FilterRequest request) {

        MarketOrders marketOrders = request.getMarketOrders();
        if (marketOrders == null) {
            log.debug(" marketOrders is null . ");
            return;
        }

        if (CollectionUtils.isEmpty(marketOrders.getPositions())) {
            log.debug(" marketOrders Positions is null . ");
            return;
        }

        List<String> positions = doFilter(marketOrders);

        removePosition(positions, marketOrders);

    }

    /**
     * 广告位相关过滤实现
     * @param marketOrders
     * @return
     */
    protected abstract List<String> doFilter(MarketOrders marketOrders);

    /**
     * 移除被过滤掉的广告位
     * @param positions
     * @param marketOrders
     */
    protected void removePosition(List<String> positions, MarketOrders marketOrders) {
        if (CollectionUtils.isEmpty(positions)) {
            return;
        }
        final Iterator<Position> iterator = marketOrders.getPositions().iterator();
        positions.forEach(position -> {
            while (iterator.hasNext()) {
                final Position next = iterator.next();
                if (next.getPositionId().equals(position)) {
                    log.debug("remove positionid = {}", position);
                    iterator.remove();
                }
            }
        });
    }
}
