package com.bxm.adx.common.filter;

import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <h3>推送广告位间隔限制过滤器</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/23 10:46
 */
@Slf4j
@Component
public class PositionPushIntervalTimesFilter extends AbstractPositionFilter {

    @Autowired
    private Counter counter;

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {

        final List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }

        List<String> list = Lists.newArrayList();

        //需要注意的是这里的position信息已经全部传过来了
        positions.forEach(position -> {

            if (position.getPushIntervalTime() == null) {
                return;
            }

            //数据来自于adxcounter
            KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "show", "user", "lasttime", position.getPositionId(), marketOrders.getUid());
            final Long lastTime = counter.get(key);


            if (lastTime == null) {
                return;
            }

            final long now = System.currentTimeMillis();
            if (now > (lastTime + (position.getPushIntervalTime() * 60 * 1000))) {
                return;
            }

            list.add(position.getPositionId());
        });

        return list;
    }

    @Override
    public int order() {
        return 2;
    }
}
