package com.bxm.adx.common.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.ip.IpResultSet;
import com.bxm.warcar.ip.MatchedIpLibrary;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * @author allen
 * @date 2019/4/12
 * @since 1.0.0
 */
@Service
public class DefaultIpServiceImpl implements IpService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIpServiceImpl.class);

    @Autowired
    @Qualifier("ipIpNetIpLibrary")
    private IpLibrary ipLibrary;
    @Autowired
    private MatchedIpLibrary matchedIpLibrary;


    private IP analyze2(String ip) {
        IP ipip = null;
        try {
            ip = fixedIp(ip);

            ipip =  getIpByIpLibrary(ip);

            if (ipip == null){
                ipip = getDefault(ip);
            }

            IpResultSet resultSet = matchedIpLibrary.find(ip);

            if (resultSet!=null){
                ipip.setStrictRegioncode(resultSet.get().getRegioncode());
            }

        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getIp: ", e);
            }
            ipip =  getDefault(ip);
        }
        return ipip;
    }

    @Override
    public IP analyze(String ip) {
        try {
            // 两种不同的方式获取地域code modify by hcmony 20190912
            IP ipip = analyze2(ip);
            if (ipip != null){
                return ipip;
            }

            ip = fixedIp(ip);

            IpResultSet resultSet = matchedIpLibrary.find(ip);
            if (null == resultSet) {
                // 如果库集返回为空，那么使用主库进行解析
                return getIpByIpLibrary(ip);
            }

            if (!resultSet.isMatched()) {
                // 如果库集中匹配失败，那么返回无行政编号的一个地址
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("IP库集匹配失败！{}", JsonHelper.convert(resultSet));
                }
                return getDefault(ip);
            }

            // 返回库集中靠前的解析结果
            IP rs = resultSet.get();
            return null == rs ? getDefault(ip) : rs;
        } catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getIp: ", e);
            }
            return getDefault(ip);
        }
    }

    private IP getIpByIpLibrary(String ip) {
        IP iprst = ipLibrary.find(ip);
        if (null == iprst) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("无法获取到IP：{} 的区域信息", ip);
            }
            iprst = getDefault(ip);
        }
        return iprst;
    }

    private IP getDefault(String ip) {
        return new IP("中国", "中国", "中国");
    }

    private static String fixedIp(String ip) {
        if (isIPv4(ip)) {
            return ip;
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Invalid ip: {}", ip);
            }
            return "127.0.0.1";
        }
    }

    private static boolean isIPv4(String ip) {
        return ip.matches("((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))");
    }

}
