package com.bxm.adx.common.sell.creatives;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2019/04/18 15:02
 */
public final class MediaEntranceCreativesBuider {

	/**
	 * 广告位素材流量比率 （每5 分钟更新一次）
	 * redis hash格式
	 * key-> ADX:POSITION:CREATIVES:FLOW:${广告位id}
	 * field->${素材id}
	 * value
	 */
	public static KeyGenerator flowRate(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION","CREATIVES", "FLOW",positionId);
	}

	/**
	 * 广告位下面所有开启的素材
	 * redis hash格式
	 * key-> AD:POSITION:MATERIALS:ALL:60fc92b97cdc44a2a38c266d91f70f84-5
	 * field->${素材id}
	 * value
	 */
	public static KeyGenerator positionAllCreatives() {
		return () -> KeyBuilder.build("ADX", "POSITION", "CREATIVES","ALL");
	}


	/**
	 * 灰度广告位
	 * @return
	 */
	public static KeyGenerator tmepPosition() {
		return () -> KeyBuilder.build("ADX","TEMP", "POSITION");
	}

	/**
	 * 流量配置
	 * @return
	 */
	public static KeyGenerator tmepConfig() {
		return () -> KeyBuilder.build("ADX","TEMP", "CONFIG");
	}

	/**
	 * 素材的点击曝光（广告位维度）
	 * ADX:POSITION:ASSETS:CLICK:VIEW:${positionid}
	 * @return
	 */
	public static KeyGenerator positionAllAssets(String positionId) {
		return () -> KeyBuilder.build("ADX", "POSITION", "ASSETS","CLICK","VIEW" ,positionId);
	}

	/**
	 * 素材的点击曝光（用户维度）
	 * ADX:USER:ASSETS:CLICK:VIEW:${userId}
	 * @return
	 */
	public static KeyGenerator userAllAssets(String userId) {
		return () -> KeyBuilder.build("ADX", "USER", "ASSETS","CLICK","VIEW" ,userId);
	}
}
