package com.bxm.adx.common.sell.position.verify;

import com.bxm.adx.common.sell.app.AppService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * Created by Arei on 2020/12/14.
 */
@Slf4j
@Component
public class AppVerify extends AbstractVerify {
    private final AppService appService;

    public AppVerify(AppService appService) {
        this.appService = appService;
    }

    @Override
    public void verify(Context context) {
        if (context.isResult()) {
            return;
        }
        Position position = context.getPosition();
        String appId = position.getAppId();
        com.bxm.adx.facade.rule.app.App app = appService.getAppById(appId);
        if (app == null) {
            if (log.isWarnEnabled()) {
                log.warn("app is null");
            }
            return;
        }
        String aid = context.getAppId();
        if (!StringUtils.isEmpty(context.getSdkVer()) && isNeedVerifyAppId(context.getSdkVer())) {
            if (StringUtils.isEmpty(aid)) {
                if (log.isWarnEnabled()) {
                    log.warn("aid is null");
                }
                return;
            }
            if (!appId.equalsIgnoreCase(aid)) {
                if (log.isWarnEnabled()) {
                    log.warn("appid is unequal");
                }
                return;
            }
        }

        String packageName = context.getPackageName();
        String appPackageName = app.getAppPackageName();
        if (StringUtils.isEmpty(appPackageName)){
            if (log.isWarnEnabled()) {
                log.warn("appPackageName is null");
            }
            return;
        }

        if (!appPackageName.equalsIgnoreCase(packageName)) {
            if (log.isWarnEnabled()) {
                log.warn("packageName is unequal");
            }
            return;
        }

        context.setResult(true);
        return;
    }
}
