package com.bxm.adx.common.utils;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.warcar.utils.JsonHelper;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Arei on 2020/11/2.
 * adx（插件用）工具类
 */
public class AdxUtils {
    /**
     * 从BidRequest中获取用户id
     * @param request
     * @return
     */
    public static String getUid(BidRequest request) {
        Device device = request.getDevice();
        if (null != device) {
            String imei = device.getImei();
            String imeiMD5 = device.getImei_md5();
            String idfa = device.getIdfa();
            String idfaMD5 = device.getIdfa_md5();
            String dpid = device.getDpid();
            String dpidMD5 = device.getDpid_md5();
            if (!StringUtils.isEmpty(imei)) {
                return imei;
            }
            if (!StringUtils.isEmpty(imeiMD5)) {
                return imeiMD5;
            }
            if (!StringUtils.isEmpty(idfa)) {
                return idfa;
            }
            if (!StringUtils.isEmpty(idfaMD5)) {
                return idfaMD5;
            }
            if (!StringUtils.isEmpty(dpid)) {
                return dpid;
            }
            if (!StringUtils.isEmpty(dpidMD5)) {
                return dpidMD5;
            }
            return null;
        } else {
            return null;
        }
    }


    public static String getImei(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getImei())) {
                return device.getImei_md5();
            } else {
                return device.getImei();
            }
        } else {
            return null;
        }
    }

    public static String getIdfa(Device device) {
        if (null != device) {
            if (StringUtils.isEmpty(device.getIdfa())) {
                return device.getIdfa_md5();
            } else {
                return device.getIdfa();
            }
        } else {
            return null;
        }
    }

    public static Map<String, Integer> getPositionSize(String positionSize) {
        String[] split = positionSize.split("\\*");
        Map<String, Integer> sizeMap = new HashMap<>();
        if (split.length == 2) {
            if (org.apache.commons.lang3.StringUtils.isBlank(split[0])) {
                return null;
            }
            sizeMap.put("w", Integer.valueOf(split[0]));
            sizeMap.put("h", Integer.valueOf(split[1].split("\\s+")[0]));
            return sizeMap;
        }
        if (split.length < 2) {
            return null;
        }
        sizeMap.put("w", Integer.valueOf(split[0]));
        sizeMap.put("h", Integer.valueOf(split[1]));
        return sizeMap;
    }

    public static PositionJsonConfig getJsonConfig(String jsonConfig) {
        if (StringUtils.isEmpty(jsonConfig)) {
            return null;
        }
        PositionJsonConfig positionJsonConfig = JsonHelper.convert(jsonConfig, PositionJsonConfig.class);
        return positionJsonConfig;
    }
}
