/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PositionPushIntervalTimesFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionPushIntervalTimesFilter.class);
    @Autowired
    private Counter counter;

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        positions.forEach(position -> {
            if (position.getPushIntervalTime() == null) {
                return;
            }
            KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "show", "user", "lasttime", position.getPositionId(), marketOrders.getUid()});
            Long lastTime = this.counter.get(key);
            if (lastTime == null) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now > lastTime + (long)(position.getPushIntervalTime() * 60 * 1000)) {
                return;
            }
            list.add(position.getPositionId());
        });
        return list;
    }

    @Override
    public int order() {
        return 2;
    }
}

