/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.utils.AdxUtils;
import com.bxm.mcssp.common.entity.PositionJsonConfig;
import com.bxm.mcssp.common.enums.position.PositionSceneTypeEnum;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PositionPushTimesCounterFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionPushTimesCounterFilter.class);
    @Autowired
    private Counter counter;

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        positions.forEach(position -> {
            Byte pScene = position.getPositionScene();
            if (pScene == null) {
                return;
            }
            PositionSceneTypeEnum typeEnum = PositionSceneTypeEnum.get((Integer)pScene.intValue());
            if (typeEnum == null) {
                return;
            }
            Integer frequency = null;
            switch (typeEnum) {
                case PUSH: {
                    if (position.getPushTimesPerPersonPerDay() == null) {
                        return;
                    }
                    frequency = position.getPushTimesPerPersonPerDay();
                    break;
                }
                case LOCK_SCREEN: {
                    String jsonConfig = position.getJsonConfig();
                    if (StringUtils.isEmpty((Object)jsonConfig)) {
                        return;
                    }
                    PositionJsonConfig positionJsonConfig = AdxUtils.getJsonConfig(jsonConfig);
                    if (positionJsonConfig == null) {
                        return;
                    }
                    PositionJsonConfig.LockScreen lockScreen = positionJsonConfig.getLockScreen();
                    if (lockScreen == null) {
                        return;
                    }
                    if (lockScreen.getShowTimesPerPersonPerDay() == null) {
                        return;
                    }
                    frequency = lockScreen.getShowTimesPerPersonPerDay();
                    break;
                }
                default: {
                    return;
                }
            }
            if (frequency == null) {
                return;
            }
            KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"statistics", "adx", "show", "user", DateHelper.getDate(), position.getPositionId()});
            Long count = this.counter.hget(key, marketOrders.getUid());
            if (count == null || count < (long)frequency.intValue()) {
                return;
            }
            list.add(position.getPositionId());
        });
        return list;
    }

    @Override
    public int order() {
        return 1;
    }
}

