/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.filter;

import com.bxm.adx.common.filter.AbstractPositionFilter;
import com.bxm.adx.common.ip.IpService;
import com.bxm.adx.common.market.MarketOrders;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.request.Device;
import com.bxm.warcar.ip.IP;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PositionRegionLimiterFilter
extends AbstractPositionFilter {
    private static final Logger log = LoggerFactory.getLogger(PositionRegionLimiterFilter.class);
    private static final String ILLEGAL_REGION_CODE_SUFFIX = "0000";
    private final IpService ipService;

    public PositionRegionLimiterFilter(IpService ipService) {
        this.ipService = ipService;
    }

    @Override
    protected List<String> doFilter(MarketOrders marketOrders) {
        List<Position> positions = marketOrders.getPositions();
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        positions.forEach(position -> {
            String regionCode;
            IP ipp;
            String ip;
            Device device;
            String regionCodes = position.getRegion();
            if (org.springframework.util.StringUtils.isEmpty((Object)regionCodes)) {
                return;
            }
            BidRequest bidRequest = marketOrders.getBidRequest();
            if (bidRequest != null && (device = bidRequest.getDevice()) != null && !org.springframework.util.StringUtils.isEmpty((Object)(ip = device.getIp())) && (ipp = this.ipService.analyze(ip)) != null && this.isOpen(regionCodes, regionCode = ipp.getRegioncode())) {
                return;
            }
            list.add(position.getPositionId());
        });
        return list;
    }

    @Override
    public int order() {
        return 3;
    }

    private boolean isOpen(String regionCodes, String regionCode) {
        List<String> open = Arrays.asList(regionCodes.split(","));
        if (CollectionUtils.isEmpty(open)) {
            return true;
        }
        if (regionCode != null && regionCode.endsWith(ILLEGAL_REGION_CODE_SUFFIX)) {
            for (String openRegin : open) {
                if (!this.getCodeForProvince(openRegin).equals(regionCode)) continue;
                return true;
            }
        }
        return open.contains(this.getCodeForProvince(regionCode)) || open.contains(this.getCodeForCity(regionCode)) || open.contains(regionCode);
    }

    private String getCodeForProvince(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)2), (int)6, (String)"0");
    }

    private String getCodeForCity(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)4), (int)6, (String)"0");
    }
}

